/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.consent.api.ActionStatus;
import de.adorsys.psd2.consent.api.TypeAccess;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.event.EventType;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.Transactions;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountDetails;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountDetailsHolder;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountListHolder;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aBalancesReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsReportByPeriodRequest;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.consent.AccountReferenceInConsentUpdater;
import de.adorsys.psd2.xs2a.service.consent.AisConsentDataService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAccountDetailsMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAccountReferenceMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aBalanceMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aBalanceReportMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aTransactionMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiTransactionListToXs2aAccountReportMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiAccountReferenceMapper;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.ValueValidatorService;
import de.adorsys.psd2.xs2a.service.validator.ais.account.GetAccountDetailsValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.GetAccountListConsentObject;
import de.adorsys.psd2.xs2a.service.validator.ais.account.GetAccountListValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.GetBalancesReportValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.GetTransactionDetailsValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.GetTransactionsReportValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.CommonAccountBalanceRequestObject;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.CommonAccountRequestObject;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.CommonAccountTransactionsRequestObject;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.TransactionsReportByPeriodObject;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountDetails;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransaction;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransactionReport;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponseStatus;
import de.adorsys.psd2.xs2a.spi.service.AccountSpi;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.validation.annotation.Validated;

@Service
@Validated
public class AccountService {
    private static final Logger log = LoggerFactory.getLogger(AccountService.class);
    private final AccountSpi accountSpi;
    private final Xs2aToSpiAccountReferenceMapper xs2aToSpiAccountReferenceMapper;
    private final SpiToXs2aAccountDetailsMapper accountDetailsMapper;
    private final SpiToXs2aBalanceMapper balanceMapper;
    private final SpiToXs2aBalanceReportMapper balanceReportMapper;
    private final SpiToXs2aAccountReferenceMapper referenceMapper;
    private final SpiTransactionListToXs2aAccountReportMapper transactionsToAccountReportMapper;
    private final SpiToXs2aTransactionMapper spiToXs2aTransactionMapper;
    private final ValueValidatorService validatorService;
    private final Xs2aAisConsentService aisConsentService;
    private final Xs2aAisConsentMapper consentMapper;
    private final TppService tppService;
    private final AspspProfileServiceWrapper aspspProfileService;
    private final AisConsentDataService aisConsentDataService;
    private final Xs2aEventService xs2aEventService;
    private final SpiContextDataProvider spiContextDataProvider;
    private final AccountReferenceInConsentUpdater accountReferenceUpdater;
    private final SpiErrorMapper spiErrorMapper;
    private final GetAccountListValidator getAccountListValidator;
    private final GetAccountDetailsValidator getAccountDetailsValidator;
    private final GetBalancesReportValidator getBalancesReportValidator;
    private final GetTransactionsReportValidator getTransactionsReportValidator;
    private final GetTransactionDetailsValidator getTransactionDetailsValidator;
    private final RequestProviderService requestProviderService;

    public ResponseObject<Xs2aAccountListHolder> getAccountList(String consentId, boolean withBalance, String requestUri) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.READ_ACCOUNT_LIST_REQUEST_RECEIVED);
        Optional<AccountConsent> accountConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        if (!accountConsentOptional.isPresent()) {
            return ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_400)).build();
        }
        AccountConsent accountConsent = accountConsentOptional.get();
        ValidationResult validationResult = this.getAccountListValidator.validate(new GetAccountListConsentObject(accountConsent, withBalance, requestUri));
        if (validationResult.isNotValid()) {
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        SpiContextData contextData = this.getSpiContextData(accountConsent.getPsuIdDataList());
        SpiResponse spiResponse = this.accountSpi.requestAccountList(contextData, withBalance, this.consentMapper.mapToSpiAccountConsent(accountConsent), this.aisConsentDataService.getAspspConsentDataByConsentId(consentId));
        this.aisConsentDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            return ResponseObject.builder().fail(new MessageError(this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS))).build();
        }
        List<Xs2aAccountDetails> accountDetails = this.accountDetailsMapper.mapToXs2aAccountDetailsList((List)spiResponse.getPayload());
        Optional<AccountConsent> accountConsentUpdated = this.accountReferenceUpdater.updateAccountReferences(consentId, accountConsent.getAccess(), accountDetails);
        if (!accountConsentUpdated.isPresent()) {
            return ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_400)).build();
        }
        accountConsent = accountConsentUpdated.get();
        Xs2aAccountListHolder xs2aAccountListHolder = new Xs2aAccountListHolder(accountDetails, accountConsent);
        ResponseObject<Xs2aAccountListHolder> response = ResponseObject.builder().body(xs2aAccountListHolder).build();
        this.writeLogAndCheckConsent(consentId, withBalance, accountConsent, TypeAccess.ACCOUNT, response, requestUri);
        return response;
    }

    public ResponseObject<Xs2aAccountDetailsHolder> getAccountDetails(String consentId, String accountId, boolean withBalance, String requestUri) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.READ_ACCOUNT_DETAILS_REQUEST_RECEIVED);
        Optional<AccountConsent> accountConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        if (!accountConsentOptional.isPresent()) {
            return ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_400)).build();
        }
        AccountConsent accountConsent = accountConsentOptional.get();
        ValidationResult validationResult = this.getAccountDetailsValidator.validate(new CommonAccountRequestObject(accountConsent, accountId, withBalance, requestUri));
        if (validationResult.isNotValid()) {
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        Optional<SpiAccountReference> requestedAccountReference = this.findAccountReference(accountConsent.getAccess().getAccounts(), accountId);
        if (!requestedAccountReference.isPresent()) {
            return ResponseObject.builder().fail(ErrorType.AIS_401, TppMessageInformation.of(MessageErrorCode.CONSENT_INVALID)).build();
        }
        SpiContextData contextData = this.getSpiContextData(accountConsent.getPsuIdDataList());
        SpiResponse spiResponse = this.accountSpi.requestAccountDetailForAccount(contextData, withBalance, requestedAccountReference.get(), this.consentMapper.mapToSpiAccountConsent(accountConsent), this.aisConsentDataService.getAspspConsentDataByConsentId(consentId));
        this.aisConsentDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            return ResponseObject.builder().fail(this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS)).build();
        }
        SpiAccountDetails spiAccountDetails = (SpiAccountDetails)spiResponse.getPayload();
        if (spiAccountDetails == null) {
            return ResponseObject.builder().fail(ErrorType.AIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404)).build();
        }
        Xs2aAccountDetails accountDetails = this.accountDetailsMapper.mapToXs2aAccountDetails(spiAccountDetails);
        Xs2aAccountDetailsHolder xs2aAccountDetailsHolder = new Xs2aAccountDetailsHolder(accountDetails, accountConsent);
        ResponseObject<Xs2aAccountDetailsHolder> response = ResponseObject.builder().body(xs2aAccountDetailsHolder).build();
        this.writeLogAndCheckConsent(consentId, withBalance, accountConsent, TypeAccess.ACCOUNT, response, requestUri);
        return response;
    }

    public ResponseObject<Xs2aBalancesReport> getBalancesReport(String consentId, String accountId, String requestUri) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.READ_BALANCE_REQUEST_RECEIVED);
        Optional<AccountConsent> accountConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        if (!accountConsentOptional.isPresent()) {
            return ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_400)).build();
        }
        AccountConsent accountConsent = accountConsentOptional.get();
        ValidationResult validationResult = this.getBalancesReportValidator.validate(new CommonAccountBalanceRequestObject(accountConsent, requestUri));
        if (validationResult.isNotValid()) {
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        Optional<SpiAccountReference> requestedAccountReference = this.findAccountReference(accountConsent.getAccess().getBalances(), accountId);
        if (!requestedAccountReference.isPresent()) {
            return ResponseObject.builder().fail(ErrorType.AIS_401, TppMessageInformation.of(MessageErrorCode.CONSENT_INVALID)).build();
        }
        SpiContextData contextData = this.getSpiContextData(accountConsent.getPsuIdDataList());
        SpiResponse spiResponse = this.accountSpi.requestBalancesForAccount(contextData, requestedAccountReference.get(), this.consentMapper.mapToSpiAccountConsent(accountConsent), this.aisConsentDataService.getAspspConsentDataByConsentId(consentId));
        this.aisConsentDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            return ResponseObject.builder().fail(new MessageError(this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS))).build();
        }
        if (spiResponse.getPayload() == null) {
            return ResponseObject.builder().fail(ErrorType.AIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404)).build();
        }
        Xs2aBalancesReport balancesReport = this.balanceReportMapper.mapToXs2aBalancesReport((List)spiResponse.getPayload(), requestedAccountReference.get());
        ResponseObject<Xs2aBalancesReport> response = ResponseObject.builder().body(balancesReport).build();
        this.writeLogAndCheckConsent(consentId, false, accountConsent, TypeAccess.BALANCE, response, requestUri);
        return response;
    }

    public ResponseObject<Xs2aTransactionsReport> getTransactionsReportByPeriod(Xs2aTransactionsReportByPeriodRequest request) {
        String consentId = request.getConsentId();
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.READ_TRANSACTION_LIST_REQUEST_RECEIVED);
        Optional<AccountConsent> accountConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        if (!accountConsentOptional.isPresent()) {
            return ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_400)).build();
        }
        String accountId = request.getAccountId();
        String requestUri = request.getRequestUri();
        boolean withBalance = request.isWithBalance();
        AccountConsent accountConsent = accountConsentOptional.get();
        TransactionsReportByPeriodObject validatorObject = new TransactionsReportByPeriodObject(accountConsent, accountId, withBalance, requestUri, request.getEntryReferenceFrom(), request.getDeltaList(), request.getAcceptHeader());
        ValidationResult validationResult = this.getTransactionsReportValidator.validate(validatorObject);
        if (validationResult.isNotValid()) {
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        Optional<SpiAccountReference> requestedAccountReference = this.findAccountReference(accountConsent.getAccess().getTransactions(), accountId);
        if (!requestedAccountReference.isPresent()) {
            return ResponseObject.builder().fail(ErrorType.AIS_401, TppMessageInformation.of(MessageErrorCode.CONSENT_INVALID)).build();
        }
        LocalDate dateFrom = request.getDateFrom();
        LocalDate dateTo = request.getDateTo();
        LocalDate dateToChecked = Optional.ofNullable(dateTo).orElseGet(LocalDate::now);
        this.validatorService.validateAccountIdPeriod(accountId, dateFrom, dateToChecked);
        boolean isTransactionsShouldContainBalances = !this.aspspProfileService.isTransactionsWithoutBalancesSupported() || withBalance;
        SpiContextData contextData = this.getSpiContextData(accountConsent.getPsuIdDataList());
        SpiResponse spiResponse = this.accountSpi.requestTransactionsForAccount(contextData, request.getAcceptHeader(), isTransactionsShouldContainBalances, dateFrom, dateToChecked, request.getBookingStatus(), requestedAccountReference.get(), this.consentMapper.mapToSpiAccountConsent(accountConsent), this.aisConsentDataService.getAspspConsentDataByConsentId(consentId));
        this.aisConsentDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            if (spiResponse.getResponseStatus() == SpiResponseStatus.NOT_SUPPORTED) {
                return ResponseObject.builder().fail(ErrorType.AIS_406, TppMessageInformation.of(MessageErrorCode.REQUESTED_FORMATS_INVALID)).build();
            }
            return ResponseObject.builder().fail(this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS)).build();
        }
        SpiTransactionReport spiTransactionReport = (SpiTransactionReport)spiResponse.getPayload();
        if (spiTransactionReport == null) {
            return ResponseObject.builder().fail(ErrorType.AIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404)).build();
        }
        Optional<Xs2aAccountReport> report = this.transactionsToAccountReportMapper.mapToXs2aAccountReport(spiTransactionReport.getTransactions(), spiTransactionReport.getTransactionsRaw());
        Xs2aTransactionsReport transactionsReport = new Xs2aTransactionsReport();
        transactionsReport.setAccountReport(report.orElseGet(() -> new Xs2aAccountReport(Collections.emptyList(), Collections.emptyList(), null)));
        transactionsReport.setAccountReference(this.referenceMapper.mapToXs2aAccountReference(requestedAccountReference.get()).orElse(null));
        transactionsReport.setBalances(this.balanceMapper.mapToXs2aBalanceList(spiTransactionReport.getBalances()));
        transactionsReport.setResponseContentType(spiTransactionReport.getResponseContentType());
        ResponseObject<Xs2aTransactionsReport> response = ResponseObject.builder().body(transactionsReport).build();
        this.writeLogAndCheckConsent(consentId, withBalance, accountConsent, TypeAccess.TRANSACTION, response, requestUri);
        return response;
    }

    public ResponseObject<Transactions> getTransactionDetails(String consentId, String accountId, String transactionId, String requestUri) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.READ_TRANSACTION_DETAILS_REQUEST_RECEIVED);
        Optional<AccountConsent> accountConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        if (!accountConsentOptional.isPresent()) {
            return ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_400)).build();
        }
        AccountConsent accountConsent = accountConsentOptional.get();
        ValidationResult validationResult = this.getTransactionDetailsValidator.validate(new CommonAccountTransactionsRequestObject(accountConsent, requestUri));
        if (validationResult.isNotValid()) {
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        Optional<SpiAccountReference> requestedAccountReference = this.findAccountReference(accountConsent.getAccess().getTransactions(), accountId);
        if (!requestedAccountReference.isPresent()) {
            return ResponseObject.builder().fail(ErrorType.AIS_401, TppMessageInformation.of(MessageErrorCode.CONSENT_INVALID)).build();
        }
        this.validatorService.validateAccountIdTransactionId(accountId, transactionId);
        SpiContextData contextData = this.getSpiContextData(accountConsent.getPsuIdDataList());
        SpiResponse spiResponse = this.accountSpi.requestTransactionForAccountByTransactionId(contextData, transactionId, requestedAccountReference.get(), this.consentMapper.mapToSpiAccountConsent(accountConsent), this.aisConsentDataService.getAspspConsentDataByConsentId(consentId));
        this.aisConsentDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            return ResponseObject.builder().fail(new MessageError(this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS))).build();
        }
        SpiTransaction payload = (SpiTransaction)spiResponse.getPayload();
        if (payload == null) {
            return ResponseObject.builder().fail(ErrorType.AIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404)).build();
        }
        Transactions transactions = this.spiToXs2aTransactionMapper.mapToXs2aTransaction(payload);
        ResponseObject<Transactions> response = ResponseObject.builder().body(transactions).build();
        this.writeLogAndCheckConsent(consentId, false, accountConsent, TypeAccess.TRANSACTION, response, requestUri);
        return response;
    }

    private void writeLogAndCheckConsent(String consentId, boolean withBalance, AccountConsent accountConsent, TypeAccess typeAccess, ResponseObject response, String requestUri) {
        this.aisConsentService.consentActionLog(this.tppService.getTppId(), consentId, this.createActionStatus(withBalance, typeAccess, response), requestUri, this.needsToUpdateUsage(accountConsent));
        this.checkAndExpireConsentIfOneAccessType(accountConsent, consentId);
    }

    private boolean needsToUpdateUsage(AccountConsent accountConsent) {
        return accountConsent.isOneAccessType() || this.requestProviderService.isRequestFromTPP();
    }

    private ActionStatus createActionStatus(boolean withBalance, TypeAccess access, ResponseObject response) {
        return response.hasError() ? this.consentMapper.mapActionStatusError(response.getError().getTppMessage().getMessageErrorCode(), withBalance, access) : ActionStatus.SUCCESS;
    }

    private Optional<SpiAccountReference> findAccountReference(List<AccountReference> references, String resourceId) {
        return references.stream().filter(accountReference -> StringUtils.equals((CharSequence)accountReference.getResourceId(), (CharSequence)resourceId)).findFirst().map(this.xs2aToSpiAccountReferenceMapper::mapToSpiAccountReference);
    }

    private void checkAndExpireConsentIfOneAccessType(AccountConsent accountConsent, String encryptedConsentId) {
        if (accountConsent.isOneAccessType()) {
            this.aisConsentService.updateConsentStatus(encryptedConsentId, ConsentStatus.EXPIRED);
        }
    }

    private SpiContextData getSpiContextData(List<PsuIdData> psuIdDataList) {
        return this.spiContextDataProvider.provideWithPsuIdData(CollectionUtils.isNotEmpty(psuIdDataList) ? psuIdDataList.get(0) : null);
    }

    @ConstructorProperties(value={"accountSpi", "xs2aToSpiAccountReferenceMapper", "accountDetailsMapper", "balanceMapper", "balanceReportMapper", "referenceMapper", "transactionsToAccountReportMapper", "spiToXs2aTransactionMapper", "validatorService", "aisConsentService", "consentMapper", "tppService", "aspspProfileService", "aisConsentDataService", "xs2aEventService", "spiContextDataProvider", "accountReferenceUpdater", "spiErrorMapper", "getAccountListValidator", "getAccountDetailsValidator", "getBalancesReportValidator", "getTransactionsReportValidator", "getTransactionDetailsValidator", "requestProviderService"})
    public AccountService(AccountSpi accountSpi, Xs2aToSpiAccountReferenceMapper xs2aToSpiAccountReferenceMapper, SpiToXs2aAccountDetailsMapper accountDetailsMapper, SpiToXs2aBalanceMapper balanceMapper, SpiToXs2aBalanceReportMapper balanceReportMapper, SpiToXs2aAccountReferenceMapper referenceMapper, SpiTransactionListToXs2aAccountReportMapper transactionsToAccountReportMapper, SpiToXs2aTransactionMapper spiToXs2aTransactionMapper, ValueValidatorService validatorService, Xs2aAisConsentService aisConsentService, Xs2aAisConsentMapper consentMapper, TppService tppService, AspspProfileServiceWrapper aspspProfileService, AisConsentDataService aisConsentDataService, Xs2aEventService xs2aEventService, SpiContextDataProvider spiContextDataProvider, AccountReferenceInConsentUpdater accountReferenceUpdater, SpiErrorMapper spiErrorMapper, GetAccountListValidator getAccountListValidator, GetAccountDetailsValidator getAccountDetailsValidator, GetBalancesReportValidator getBalancesReportValidator, GetTransactionsReportValidator getTransactionsReportValidator, GetTransactionDetailsValidator getTransactionDetailsValidator, RequestProviderService requestProviderService) {
        this.accountSpi = accountSpi;
        this.xs2aToSpiAccountReferenceMapper = xs2aToSpiAccountReferenceMapper;
        this.accountDetailsMapper = accountDetailsMapper;
        this.balanceMapper = balanceMapper;
        this.balanceReportMapper = balanceReportMapper;
        this.referenceMapper = referenceMapper;
        this.transactionsToAccountReportMapper = transactionsToAccountReportMapper;
        this.spiToXs2aTransactionMapper = spiToXs2aTransactionMapper;
        this.validatorService = validatorService;
        this.aisConsentService = aisConsentService;
        this.consentMapper = consentMapper;
        this.tppService = tppService;
        this.aspspProfileService = aspspProfileService;
        this.aisConsentDataService = aisConsentDataService;
        this.xs2aEventService = xs2aEventService;
        this.spiContextDataProvider = spiContextDataProvider;
        this.accountReferenceUpdater = accountReferenceUpdater;
        this.spiErrorMapper = spiErrorMapper;
        this.getAccountListValidator = getAccountListValidator;
        this.getAccountDetailsValidator = getAccountDetailsValidator;
        this.getBalancesReportValidator = getBalancesReportValidator;
        this.getTransactionsReportValidator = getTransactionsReportValidator;
        this.getTransactionDetailsValidator = getTransactionDetailsValidator;
        this.requestProviderService = requestProviderService;
    }
}

