/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.exception;

import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import org.springframework.http.HttpStatus;

public class RestException
extends RuntimeException {
    private HttpStatus httpStatus;
    private String message;
    private MessageErrorCode messageErrorCode = MessageErrorCode.INTERNAL_SERVER_ERROR;

    public RestException(HttpStatus httpStatus, String message) {
        this.httpStatus = httpStatus;
        this.message = message;
    }

    public RestException(MessageErrorCode messageErrorCode) {
        this.messageErrorCode = messageErrorCode;
        this.httpStatus = HttpStatus.valueOf((int)messageErrorCode.getCode());
        this.message = this.httpStatus.getReasonPhrase();
    }

    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public MessageErrorCode getMessageErrorCode() {
        return this.messageErrorCode;
    }
}

