/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.component;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;

public class AcceptContentTypeDeserializer
extends StdDeserializer<MediaType[]> {
    private static final Logger log = LoggerFactory.getLogger(AcceptContentTypeDeserializer.class);
    private static final List<MediaType> ALLOWED_TYPES = new ArrayList<MediaType>();

    public AcceptContentTypeDeserializer() {
        super(MediaType[].class);
    }

    public MediaType[] deserialize(JsonParser jsonParser, DeserializationContext ctxt) {
        try {
            String parsedText = jsonParser.getText();
            List mediaTypes = MediaType.parseMediaTypes((String)parsedText);
            mediaTypes.removeIf(e -> !ALLOWED_TYPES.contains(e));
            if (!mediaTypes.isEmpty()) {
                return mediaTypes.toArray(new MediaType[0]);
            }
        }
        catch (IOException e2) {
            log.error("Unsupported Accept header value format!");
        }
        throw new IllegalArgumentException("Unsupported 'Accept' header values");
    }

    static {
        ALLOWED_TYPES.add(MediaType.APPLICATION_JSON);
        ALLOWED_TYPES.add(MediaType.APPLICATION_XML);
        ALLOWED_TYPES.add(MediaType.TEXT_PLAIN);
        ALLOWED_TYPES.add(MediaType.ALL);
    }
}

