/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body.consent;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.model.Consents;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.body.AbstractBodyValidatorImpl;
import de.adorsys.psd2.xs2a.web.validator.body.consent.ConsentBodyValidator;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConsentBodyFieldsValidatorImpl
extends AbstractBodyValidatorImpl
implements ConsentBodyValidator {
    @Autowired
    public ConsentBodyFieldsValidatorImpl(ErrorBuildingService errorBuildingService, ObjectMapper objectMapper) {
        super(errorBuildingService, objectMapper);
    }

    @Override
    public void validate(HttpServletRequest request, MessageError messageError) {
        Optional<Consents> consentsOptional = this.mapBodyToInstance(request, messageError, Consents.class);
        if (!consentsOptional.isPresent()) {
            return;
        }
        Consents consents = consentsOptional.get();
        if (Objects.isNull(consents.getRecurringIndicator())) {
            this.errorBuildingService.enrichMessageError(messageError, "Value 'recurringIndicator' should not be null");
        }
        if (Objects.isNull(consents.getValidUntil())) {
            this.errorBuildingService.enrichMessageError(messageError, "Value 'validUntil' should not be null");
        } else {
            this.validateValidUntil(consents.getValidUntil(), messageError);
        }
        if (Objects.isNull(consents.getFrequencyPerDay())) {
            this.errorBuildingService.enrichMessageError(messageError, "Value 'frequencyPerDay' should not be null");
        } else {
            this.validateFrequencyPerDay(consents.getFrequencyPerDay(), messageError);
        }
    }

    private void validateValidUntil(LocalDate validUntil, MessageError messageError) {
        if (validUntil.isBefore(LocalDate.now())) {
            this.errorBuildingService.enrichMessageError(messageError, "Value 'validUntil' should not be in the past");
        }
    }

    private void validateFrequencyPerDay(Integer frequencyPerDay, MessageError messageError) {
        if (frequencyPerDay < 1) {
            this.errorBuildingService.enrichMessageError(messageError, "Value 'frequencyPerDay' should not be lower than 1");
        }
    }
}

