/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.link;

import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthenticationObject;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataRequest;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.web.link.AbstractLinks;

public class UpdatePisPsuDataLinks
extends AbstractLinks {
    private ScaApproachResolver scaApproachResolver;

    public UpdatePisPsuDataLinks(String httpUrl, ScaApproachResolver scaApproachResolver, Xs2aUpdatePisCommonPaymentPsuDataRequest request, ScaStatus scaStatus, Xs2aAuthenticationObject chosenScaMethod) {
        super(httpUrl);
        this.scaApproachResolver = scaApproachResolver;
        this.setSelf(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}", request.getPaymentService(), request.getPaymentProduct(), request.getPaymentId()));
        this.setStatus(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/status", request.getPaymentService(), request.getPaymentProduct(), request.getPaymentId()));
        if (this.isScaStatusMethodAuthenticated(scaStatus)) {
            this.setSelectAuthenticationMethod(this.buildAuthorisationLink(request));
        } else if (this.isScaStatusMethodSelected(chosenScaMethod, scaStatus) && this.isEmbeddedScaApproach(request.getAuthorisationId())) {
            this.setAuthoriseTransaction(this.buildAuthorisationLink(request));
        } else if (this.isScaStatusFinalised(scaStatus)) {
            this.setScaStatus(this.buildAuthorisationLink(request));
        } else if (this.isScaStatusMethodIdentified(scaStatus)) {
            this.setUpdatePsuAuthentication(this.buildAuthorisationLink(request));
        }
    }

    private String buildAuthorisationLink(Xs2aUpdatePisCommonPaymentPsuDataRequest request) {
        return this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/authorisations/{authorisation-id}", request.getPaymentService(), request.getPaymentProduct(), request.getPaymentId(), request.getAuthorisationId());
    }

    private boolean isEmbeddedScaApproach(String authorisationId) {
        return this.scaApproachResolver.getInitiationScaApproach(authorisationId) == ScaApproach.EMBEDDED;
    }

    private boolean isScaStatusFinalised(ScaStatus scaStatus) {
        return scaStatus == ScaStatus.FINALISED;
    }

    private boolean isScaStatusMethodSelected(Xs2aAuthenticationObject chosenScaMethod, ScaStatus scaStatus) {
        return chosenScaMethod != null && scaStatus == ScaStatus.SCAMETHODSELECTED;
    }

    private boolean isScaStatusMethodAuthenticated(ScaStatus scaStatus) {
        return scaStatus == ScaStatus.PSUAUTHENTICATED;
    }

    private boolean isScaStatusMethodIdentified(ScaStatus scaStatus) {
        return scaStatus == ScaStatus.PSUIDENTIFIED;
    }
}

