/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.link;

import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.web.link.AbstractLinks;

public class UpdateConsentLinks
extends AbstractLinks {
    public UpdateConsentLinks(String httpUrl, ScaApproachResolver scaApproachResolver, UpdateConsentPsuDataResponse response) {
        super(httpUrl);
        String consentId = response.getConsentId();
        String authorisationId = response.getAuthorisationId();
        ScaStatus scaStatus = response.getScaStatus();
        this.setSelf(this.buildPath("/v1/consents/{consentId}", consentId));
        this.setStatus(this.buildPath("/v1/consents/{consentId}/status", consentId));
        if (scaStatus == ScaStatus.PSUAUTHENTICATED) {
            this.setSelectAuthenticationMethod(this.buildPath("/v1/consents/{consentId}/authorisations/{authorisation-id}", consentId, authorisationId));
        } else if (scaStatus == ScaStatus.SCAMETHODSELECTED) {
            ScaApproach scaApproach = scaApproachResolver.getInitiationScaApproach(authorisationId);
            if (scaApproach == ScaApproach.DECOUPLED) {
                this.setScaStatus(this.buildPath("/v1/consents/{consentId}/authorisations/{authorisation-id}", consentId, authorisationId));
            } else {
                this.setAuthoriseTransaction(this.buildPath("/v1/consents/{consentId}/authorisations/{authorisation-id}", consentId, authorisationId));
            }
        } else if (scaStatus == ScaStatus.FINALISED) {
            this.setScaStatus(this.buildPath("/v1/consents/{consentId}/authorisations/{authorisation-id}", consentId, authorisationId));
        } else if (scaStatus == ScaStatus.PSUIDENTIFIED) {
            this.setStartAuthorisationWithPsuAuthentication(this.buildPath("/v1/consents/{consentId}/authorisations/{authorisation-id}", consentId, authorisationId));
        }
    }
}

