/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.link;

import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.profile.ScaRedirectFlow;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.web.RedirectLinkBuilder;
import de.adorsys.psd2.xs2a.web.link.AbstractLinks;
import java.util.EnumSet;

public class PisAuthorisationCancellationLinks
extends AbstractLinks {
    private RedirectLinkBuilder redirectLinkBuilder;
    private ScaRedirectFlow scaRedirectFlow;

    public PisAuthorisationCancellationLinks(String httpUrl, ScaApproachResolver scaApproachResolver, RedirectLinkBuilder redirectLinkBuilder, String paymentService, String paymentProduct, String paymentId, String authorizationId, PsuIdData psuData, ScaRedirectFlow scaRedirectFlow) {
        super(httpUrl);
        this.redirectLinkBuilder = redirectLinkBuilder;
        this.scaRedirectFlow = scaRedirectFlow;
        this.setSelf(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}", paymentService, paymentProduct, paymentId));
        this.setStatus(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/status", paymentService, paymentProduct, paymentId));
        ScaApproach cancellationScaApproach = scaApproachResolver.getCancellationScaApproach(authorizationId);
        if (EnumSet.of(ScaApproach.EMBEDDED, ScaApproach.DECOUPLED).contains(cancellationScaApproach)) {
            this.addEmbeddedDecoupledRelatedLinks(paymentService, paymentProduct, paymentId, authorizationId, psuData);
        } else if (cancellationScaApproach == ScaApproach.REDIRECT) {
            this.addRedirectRelatedLinks(paymentService, paymentProduct, paymentId, authorizationId);
        } else if (cancellationScaApproach == ScaApproach.OAUTH) {
            this.setScaOAuth("scaOAuth");
        }
    }

    private void addEmbeddedDecoupledRelatedLinks(String paymentService, String paymentProduct, String paymentId, String authorizationId, PsuIdData psuData) {
        String path = "/v1/{payment-service}/{payment-product}/{payment-id}/cancellation-authorisations/{authorisation-id}";
        if (psuData.isEmpty()) {
            this.setUpdatePsuIdentification(this.buildPath(path, paymentService, paymentProduct, paymentId, authorizationId));
        } else {
            this.setUpdatePsuAuthentication(this.buildPath(path, paymentService, paymentProduct, paymentId, authorizationId));
        }
    }

    private void addRedirectRelatedLinks(String paymentService, String paymentProduct, String paymentId, String authorizationId) {
        this.setScaRedirectOAuthLink(this.scaRedirectFlow, this.redirectLinkBuilder.buildPaymentCancellationScaRedirectLink(paymentId, authorizationId));
        this.setScaStatus(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/cancellation-authorisations/{authorisation-id}", paymentService, paymentProduct, paymentId, authorizationId));
    }
}

