/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator;

import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.profile.AccountReferenceType;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.account.SupportedAccountReferenceField;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.discovery.ServiceTypeDiscoveryService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceTypeToErrorTypeMapper;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.BusinessValidator;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SupportedAccountReferenceValidator
implements BusinessValidator<Collection<AccountReference>> {
    private static final Logger log = LoggerFactory.getLogger(SupportedAccountReferenceValidator.class);
    private static final String MESSAGE_ERROR_ATTRIBUTE_NOT_SUPPORTED = "Attribute %s is not supported by the ASPSP";
    private final AspspProfileServiceWrapper aspspProfileService;
    private final RequestProviderService requestProviderService;
    private final ServiceTypeDiscoveryService serviceTypeDiscoveryService;
    private final ServiceTypeToErrorTypeMapper errorTypeMapper;

    @Override
    @NotNull
    public ValidationResult validate(@NotNull Collection<AccountReference> accountReferences) {
        if (accountReferences.isEmpty()) {
            return ValidationResult.valid();
        }
        List<SupportedAccountReferenceField> supportedAccountReferenceFields = this.aspspProfileService.getSupportedAccountReferenceFields();
        Optional<ValidationResult> failedValidationResult = accountReferences.stream().map(ar -> this.validateAccountReference((AccountReference)ar, (Collection<SupportedAccountReferenceField>)supportedAccountReferenceFields)).filter(ValidationResult::isNotValid).findFirst();
        return failedValidationResult.orElseGet(ValidationResult::valid);
    }

    private ValidationResult validateAccountReference(AccountReference accountReference, Collection<SupportedAccountReferenceField> supportedFields) {
        AccountReferenceType usedAccountReferenceType = accountReference.getUsedAccountReferenceSelector().getAccountReferenceType();
        boolean referenceSupported = supportedFields.stream().map(f -> AccountReferenceType.valueOf((String)f.name())).anyMatch(arg_0 -> usedAccountReferenceType.equals(arg_0));
        if (referenceSupported) {
            return ValidationResult.valid();
        }
        log.info("X-Request-ID: [{}]. Supported account reference validation has failed: account reference type {} is not supported by the ASPSP", (Object)this.requestProviderService.getRequestId(), (Object)usedAccountReferenceType);
        ErrorType errorType = this.errorTypeMapper.mapToErrorType(this.serviceTypeDiscoveryService.getServiceType(), MessageErrorCode.FORMAT_ERROR.getCode());
        return ValidationResult.invalid(errorType, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR, String.format(MESSAGE_ERROR_ATTRIBUTE_NOT_SUPPORTED, usedAccountReferenceType.toString())));
    }

    @ConstructorProperties(value={"aspspProfileService", "requestProviderService", "serviceTypeDiscoveryService", "errorTypeMapper"})
    public SupportedAccountReferenceValidator(AspspProfileServiceWrapper aspspProfileService, RequestProviderService requestProviderService, ServiceTypeDiscoveryService serviceTypeDiscoveryService, ServiceTypeToErrorTypeMapper errorTypeMapper) {
        this.aspspProfileService = aspspProfileService;
        this.requestProviderService = requestProviderService;
        this.serviceTypeDiscoveryService = serviceTypeDiscoveryService;
        this.errorTypeMapper = errorTypeMapper;
    }
}

