/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator;

import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.discovery.ServiceTypeDiscoveryService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceTypeToErrorTypeMapper;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.BusinessValidator;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import java.beans.ConstructorProperties;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PsuDataInInitialRequestValidator
implements BusinessValidator<PsuIdData> {
    private static final Logger log = LoggerFactory.getLogger(PsuDataInInitialRequestValidator.class);
    private static final String MESSAGE_ERROR_PSU_ID_BLANK = "PSU-ID should not be blank";
    private static final String MESSAGE_ERROR_NO_PSU_ID = "PSU-ID is missing in request";
    private final AspspProfileServiceWrapper aspspProfileService;
    private final RequestProviderService requestProviderService;
    private final ServiceTypeDiscoveryService serviceTypeDiscoveryService;
    private final ServiceTypeToErrorTypeMapper errorTypeMapper;

    @Override
    @NotNull
    public ValidationResult validate(@NotNull PsuIdData psuIdData) {
        String psuId = psuIdData.getPsuId();
        if (this.aspspProfileService.isPsuInInitialRequestMandated() && StringUtils.isBlank((CharSequence)psuId)) {
            ErrorType errorType = this.errorTypeMapper.mapToErrorType(this.serviceTypeDiscoveryService.getServiceType(), MessageErrorCode.FORMAT_ERROR.getCode());
            if (psuId == null) {
                log.info("X-Request-ID: [{}]. PSU Data validation has failed: mandated PSU ID is null", (Object)this.requestProviderService.getRequestId());
                return ValidationResult.invalid(errorType, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR, MESSAGE_ERROR_NO_PSU_ID));
            }
            log.info("X-Request-ID: [{}]. PSU Data validation has failed: mandated PSU ID is blank", (Object)this.requestProviderService.getRequestId());
            return ValidationResult.invalid(errorType, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR, MESSAGE_ERROR_PSU_ID_BLANK));
        }
        return ValidationResult.valid();
    }

    @ConstructorProperties(value={"aspspProfileService", "requestProviderService", "serviceTypeDiscoveryService", "errorTypeMapper"})
    public PsuDataInInitialRequestValidator(AspspProfileServiceWrapper aspspProfileService, RequestProviderService requestProviderService, ServiceTypeDiscoveryService serviceTypeDiscoveryService, ServiceTypeToErrorTypeMapper errorTypeMapper) {
        this.aspspProfileService = aspspProfileService;
        this.requestProviderService = requestProviderService;
        this.serviceTypeDiscoveryService = serviceTypeDiscoveryService;
        this.errorTypeMapper = errorTypeMapper;
    }
}

