/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.psd2.piis;

import de.adorsys.psd2.model.Error403NGPIIS;
import de.adorsys.psd2.model.MessageCode403PIIS;
import de.adorsys.psd2.model.TppMessage403PIIS;
import de.adorsys.psd2.model.TppMessageCategory;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.mapper.psd2.Psd2ErrorMapper;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class PIIS403ErrorMapper
extends Psd2ErrorMapper<MessageError, Error403NGPIIS> {
    @Override
    public Function<MessageError, Error403NGPIIS> getMapper() {
        return this::mapToPsd2Error;
    }

    @Override
    public HttpStatus getErrorStatus() {
        return HttpStatus.FORBIDDEN;
    }

    private Error403NGPIIS mapToPsd2Error(MessageError messageError) {
        return new Error403NGPIIS().tppMessages(this.mapToTppMessage403PIIS(messageError.getTppMessages()));
    }

    private List<TppMessage403PIIS> mapToTppMessage403PIIS(Set<TppMessageInformation> tppMessages) {
        return tppMessages.stream().map(m -> new TppMessage403PIIS().category(TppMessageCategory.fromValue((String)m.getCategory().name())).code(MessageCode403PIIS.fromValue((String)m.getMessageErrorCode().getName())).path(m.getPath()).text(this.getErrorText((TppMessageInformation)m))).collect(Collectors.toList());
    }
}

