/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.domain.pis;

import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.AccountReferenceCollector;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;

public class BulkPayment
implements AccountReferenceCollector {
    private String paymentId;
    private Boolean batchBookingPreferred;
    @NotNull
    private AccountReference debtorAccount;
    private LocalDate requestedExecutionDate;
    private OffsetDateTime requestedExecutionTime;
    private List<SinglePayment> payments;
    private TransactionStatus transactionStatus;
    private List<PsuIdData> psuDataList;
    private OffsetDateTime statusChangeTimestamp;

    @Override
    public Set<AccountReference> getAccountReferences() {
        Set<AccountReference> accountReferences = this.payments.stream().map(SinglePayment::getAccountReferences).flatMap(Collection::stream).collect(Collectors.toSet());
        accountReferences.add(this.debtorAccount);
        return accountReferences;
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public Boolean getBatchBookingPreferred() {
        return this.batchBookingPreferred;
    }

    public AccountReference getDebtorAccount() {
        return this.debtorAccount;
    }

    public LocalDate getRequestedExecutionDate() {
        return this.requestedExecutionDate;
    }

    public OffsetDateTime getRequestedExecutionTime() {
        return this.requestedExecutionTime;
    }

    public List<SinglePayment> getPayments() {
        return this.payments;
    }

    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public List<PsuIdData> getPsuDataList() {
        return this.psuDataList;
    }

    public OffsetDateTime getStatusChangeTimestamp() {
        return this.statusChangeTimestamp;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public void setBatchBookingPreferred(Boolean batchBookingPreferred) {
        this.batchBookingPreferred = batchBookingPreferred;
    }

    public void setDebtorAccount(AccountReference debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public void setRequestedExecutionDate(LocalDate requestedExecutionDate) {
        this.requestedExecutionDate = requestedExecutionDate;
    }

    public void setRequestedExecutionTime(OffsetDateTime requestedExecutionTime) {
        this.requestedExecutionTime = requestedExecutionTime;
    }

    public void setPayments(List<SinglePayment> payments) {
        this.payments = payments;
    }

    public void setTransactionStatus(TransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public void setPsuDataList(List<PsuIdData> psuDataList) {
        this.psuDataList = psuDataList;
    }

    public void setStatusChangeTimestamp(OffsetDateTime statusChangeTimestamp) {
        this.statusChangeTimestamp = statusChangeTimestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BulkPayment)) {
            return false;
        }
        BulkPayment other = (BulkPayment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$paymentId = this.getPaymentId();
        String other$paymentId = other.getPaymentId();
        if (this$paymentId == null ? other$paymentId != null : !this$paymentId.equals(other$paymentId)) {
            return false;
        }
        Boolean this$batchBookingPreferred = this.getBatchBookingPreferred();
        Boolean other$batchBookingPreferred = other.getBatchBookingPreferred();
        if (this$batchBookingPreferred == null ? other$batchBookingPreferred != null : !((Object)this$batchBookingPreferred).equals(other$batchBookingPreferred)) {
            return false;
        }
        AccountReference this$debtorAccount = this.getDebtorAccount();
        AccountReference other$debtorAccount = other.getDebtorAccount();
        if (this$debtorAccount == null ? other$debtorAccount != null : !this$debtorAccount.equals(other$debtorAccount)) {
            return false;
        }
        LocalDate this$requestedExecutionDate = this.getRequestedExecutionDate();
        LocalDate other$requestedExecutionDate = other.getRequestedExecutionDate();
        if (this$requestedExecutionDate == null ? other$requestedExecutionDate != null : !((Object)this$requestedExecutionDate).equals(other$requestedExecutionDate)) {
            return false;
        }
        OffsetDateTime this$requestedExecutionTime = this.getRequestedExecutionTime();
        OffsetDateTime other$requestedExecutionTime = other.getRequestedExecutionTime();
        if (this$requestedExecutionTime == null ? other$requestedExecutionTime != null : !((Object)this$requestedExecutionTime).equals(other$requestedExecutionTime)) {
            return false;
        }
        List<SinglePayment> this$payments = this.getPayments();
        List<SinglePayment> other$payments = other.getPayments();
        if (this$payments == null ? other$payments != null : !((Object)this$payments).equals(other$payments)) {
            return false;
        }
        TransactionStatus this$transactionStatus = this.getTransactionStatus();
        TransactionStatus other$transactionStatus = other.getTransactionStatus();
        if (this$transactionStatus == null ? other$transactionStatus != null : !this$transactionStatus.equals(other$transactionStatus)) {
            return false;
        }
        List<PsuIdData> this$psuDataList = this.getPsuDataList();
        List<PsuIdData> other$psuDataList = other.getPsuDataList();
        if (this$psuDataList == null ? other$psuDataList != null : !((Object)this$psuDataList).equals(other$psuDataList)) {
            return false;
        }
        OffsetDateTime this$statusChangeTimestamp = this.getStatusChangeTimestamp();
        OffsetDateTime other$statusChangeTimestamp = other.getStatusChangeTimestamp();
        return !(this$statusChangeTimestamp == null ? other$statusChangeTimestamp != null : !((Object)this$statusChangeTimestamp).equals(other$statusChangeTimestamp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BulkPayment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $paymentId = this.getPaymentId();
        result = result * 59 + ($paymentId == null ? 43 : $paymentId.hashCode());
        Boolean $batchBookingPreferred = this.getBatchBookingPreferred();
        result = result * 59 + ($batchBookingPreferred == null ? 43 : ((Object)$batchBookingPreferred).hashCode());
        AccountReference $debtorAccount = this.getDebtorAccount();
        result = result * 59 + ($debtorAccount == null ? 43 : $debtorAccount.hashCode());
        LocalDate $requestedExecutionDate = this.getRequestedExecutionDate();
        result = result * 59 + ($requestedExecutionDate == null ? 43 : ((Object)$requestedExecutionDate).hashCode());
        OffsetDateTime $requestedExecutionTime = this.getRequestedExecutionTime();
        result = result * 59 + ($requestedExecutionTime == null ? 43 : ((Object)$requestedExecutionTime).hashCode());
        List<SinglePayment> $payments = this.getPayments();
        result = result * 59 + ($payments == null ? 43 : ((Object)$payments).hashCode());
        TransactionStatus $transactionStatus = this.getTransactionStatus();
        result = result * 59 + ($transactionStatus == null ? 43 : $transactionStatus.hashCode());
        List<PsuIdData> $psuDataList = this.getPsuDataList();
        result = result * 59 + ($psuDataList == null ? 43 : ((Object)$psuDataList).hashCode());
        OffsetDateTime $statusChangeTimestamp = this.getStatusChangeTimestamp();
        result = result * 59 + ($statusChangeTimestamp == null ? 43 : ((Object)$statusChangeTimestamp).hashCode());
        return result;
    }

    public String toString() {
        return "BulkPayment(paymentId=" + this.getPaymentId() + ", batchBookingPreferred=" + this.getBatchBookingPreferred() + ", debtorAccount=" + this.getDebtorAccount() + ", requestedExecutionDate=" + this.getRequestedExecutionDate() + ", requestedExecutionTime=" + this.getRequestedExecutionTime() + ", payments=" + this.getPayments() + ", transactionStatus=" + this.getTransactionStatus() + ", psuDataList=" + this.getPsuDataList() + ", statusChangeTimestamp=" + this.getStatusChangeTimestamp() + ")";
    }
}

