/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.header;

import com.google.common.net.InternetDomainName;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import java.beans.ConstructorProperties;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TppDomainValidator {
    private static final Logger log = LoggerFactory.getLogger(TppDomainValidator.class);
    public static final String ERROR_TEXT = "URIs don't comply with domain from certificate";
    private static final String PATTERN_FOR_NORMALIZE_DOMAIN = ".*\\.(?=.*\\.)";
    private final ErrorBuildingService errorBuildingService;
    private final ScaApproachResolver scaApproachResolver;
    private final TppService tppService;
    private final RequestProviderService requestProviderService;

    public ValidationResult validate(String header) {
        if (StringUtils.isNotBlank((CharSequence)header) && this.isRedirectScaApproach()) {
            List<URL> certificateUrls = this.getDomainsFromTppInfo().stream().map(this::buildURL).filter(Objects::nonNull).collect(Collectors.toList());
            if (certificateUrls.isEmpty()) {
                return ValidationResult.valid();
            }
            URL urlHeader = this.buildURL(header);
            if (urlHeader == null) {
                return this.buildInvalidResult();
            }
            return this.isUrlCompliant(urlHeader, certificateUrls) ? ValidationResult.valid() : this.buildInvalidResult();
        }
        return ValidationResult.valid();
    }

    private boolean isUrlCompliant(URL urlHeader, List<URL> certificateUrls) {
        String topDomainUrl = this.getTopDomain(urlHeader.getHost());
        return certificateUrls.stream().map(URL::getHost).map(this::getTopDomain).filter(Objects::nonNull).anyMatch(topDomainCertificate -> Objects.equals(topDomainCertificate, topDomainUrl));
    }

    private URL buildURL(String domain) {
        try {
            String normalizedDomain = this.normalizeDomain(domain);
            URL url = new URL(this.getDomainWithProtocol(normalizedDomain));
            if (InternetDomainName.from((String)url.getHost()).isUnderPublicSuffix()) {
                return url;
            }
        }
        catch (MalformedURLException e) {
            log.warn("InR-ID: [{}], X-Request-ID: [{}] Cannot build URL from [{}]", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), domain});
        }
        return null;
    }

    private String normalizeDomain(String domain) {
        return domain.replaceAll(PATTERN_FOR_NORMALIZE_DOMAIN, "");
    }

    private List<String> getDomainsFromTppInfo() {
        TppInfo tppInfo = this.tppService.getTppInfo();
        ArrayList dnsList = new ArrayList();
        Optional.ofNullable(tppInfo.getTppName()).ifPresent(dnsList::add);
        dnsList.addAll(tppInfo.getDnsList());
        return dnsList.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    private String getDomainWithProtocol(String domain) {
        return domain.startsWith("http") ? domain : "http://" + domain;
    }

    private ValidationResult buildInvalidResult() {
        return ValidationResult.invalid(this.errorBuildingService.buildErrorType(), TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR, ERROR_TEXT));
    }

    private String getTopDomain(String host) {
        try {
            return InternetDomainName.from((String)host).topPrivateDomain().toString();
        }
        catch (IllegalStateException ex) {
            log.warn("InR-ID: [{}], X-Request-ID: [{}] Cannot get top domain from [{}]", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), host});
            return null;
        }
    }

    private boolean isRedirectScaApproach() {
        return ScaApproach.REDIRECT == this.scaApproachResolver.resolveScaApproach();
    }

    @ConstructorProperties(value={"errorBuildingService", "scaApproachResolver", "tppService", "requestProviderService"})
    public TppDomainValidator(ErrorBuildingService errorBuildingService, ScaApproachResolver scaApproachResolver, TppService tppService, RequestProviderService requestProviderService) {
        this.errorBuildingService = errorBuildingService;
        this.scaApproachResolver = scaApproachResolver;
        this.tppService = tppService;
        this.requestProviderService = requestProviderService;
    }
}

