/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.xs2a.domain.pis.Remittance;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.body.BodyValidator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AbstractBodyValidatorImpl
implements BodyValidator {
    protected ErrorBuildingService errorBuildingService;
    protected ObjectMapper objectMapper;

    protected AbstractBodyValidatorImpl(ErrorBuildingService errorBuildingService, ObjectMapper objectMapper) {
        this.errorBuildingService = errorBuildingService;
        this.objectMapper = objectMapper;
    }

    protected void validateBodyFields(HttpServletRequest request, MessageError messageError) {
    }

    protected void validateRawData(HttpServletRequest request, MessageError messageError) {
    }

    @Override
    public void validate(HttpServletRequest request, MessageError messageError) {
        this.validateRawData(request, messageError);
        if (CollectionUtils.isEmpty(messageError.getTppMessages())) {
            this.validateBodyFields(request, messageError);
        }
    }

    protected void checkRequiredFieldForMaxLength(String fieldToCheck, String fieldName, int maxLength, MessageError messageError) {
        if (StringUtils.isBlank((CharSequence)fieldToCheck)) {
            String text = String.format("Value '%s' cannot be empty", fieldName);
            this.errorBuildingService.enrichMessageError(messageError, text);
        } else {
            this.checkFieldForMaxLength(fieldToCheck, fieldName, maxLength, messageError);
        }
    }

    protected void checkOptionalFieldForMaxLength(String field, String fieldName, int maxLength, MessageError messageError) {
        if (StringUtils.isNotBlank((CharSequence)field)) {
            this.checkFieldForMaxLength(field, fieldName, maxLength, messageError);
        }
    }

    private void checkFieldForMaxLength(@NotNull String fieldToCheck, String fieldName, int maxLength, MessageError messageError) {
        if (fieldToCheck.length() > maxLength) {
            String text = String.format("Value '%s' should not be more than %s symbols", fieldName, maxLength);
            this.errorBuildingService.enrichMessageError(messageError, text);
        }
    }

    protected <T> Optional<T> mapBodyToInstance(HttpServletRequest request, MessageError messageError, Class<T> clazz) {
        try {
            return Optional.of(this.objectMapper.readValue((InputStream)request.getInputStream(), clazz));
        }
        catch (IOException e) {
            this.errorBuildingService.enrichMessageError(messageError, "Cannot deserialize the request body");
            return Optional.empty();
        }
    }

    protected void validateUltimateDebtor(String field, MessageError messageError) {
        this.checkOptionalFieldForMaxLength(field, "ultimateDebtor", 70, messageError);
    }

    protected void validateUltimateCreditor(String field, MessageError messageError) {
        this.checkOptionalFieldForMaxLength(field, "ultimateCreditor", 70, messageError);
    }

    protected void validateRemittanceInformationStructured(Remittance remittance, MessageError messageError) {
        if (remittance != null) {
            this.checkRequiredFieldForMaxLength(remittance.getReference(), "reference", 35, messageError);
            this.checkOptionalFieldForMaxLength(remittance.getReferenceType(), "referenceType", 35, messageError);
            this.checkOptionalFieldForMaxLength(remittance.getReferenceIssuer(), "referenceIssuer", 35, messageError);
        }
    }
}

