/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.pis.authorisation.initiation;

import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.pis.PaymentAuthorisationType;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.validator.PisEndpointAccessCheckerService;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.pis.AbstractPisTppValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.PisAuthorisationValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.initiation.UpdatePisCommonPaymentPsuDataPO;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UpdatePisCommonPaymentPsuDataValidator
extends AbstractPisTppValidator<UpdatePisCommonPaymentPsuDataPO> {
    private static final Logger log = LoggerFactory.getLogger(UpdatePisCommonPaymentPsuDataValidator.class);
    private final PisEndpointAccessCheckerService pisEndpointAccessCheckerService;
    private final RequestProviderService requestProviderService;
    private final PisAuthorisationValidator pisAuthorisationValidator;

    @Override
    protected ValidationResult executeBusinessValidation(UpdatePisCommonPaymentPsuDataPO paymentObject) {
        String authorisationId = paymentObject.getAuthorisationId();
        if (!this.pisEndpointAccessCheckerService.isEndpointAccessible(authorisationId, PaymentAuthorisationType.CREATED)) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Authorisation ID: [{}]. Updating PIS initiation authorisation PSU Data  has failed: endpoint is not accessible for authorisation", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), authorisationId});
            return ValidationResult.invalid(ErrorType.PIS_403, TppMessageInformation.of(MessageErrorCode.SERVICE_BLOCKED));
        }
        PisCommonPaymentResponse pisCommonPaymentResponse = paymentObject.getPisCommonPaymentResponse();
        if (pisCommonPaymentResponse.getTransactionStatus() == TransactionStatus.RJCT) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Authorisation ID: [{}]. Updating PIS initiation authorisation PSU Data has failed: payment has been rejected", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), authorisationId});
            return ValidationResult.invalid(ErrorType.PIS_403, TppMessageInformation.of(MessageErrorCode.RESOURCE_EXPIRED_403));
        }
        ValidationResult authorisationValidationResult = this.pisAuthorisationValidator.validate(authorisationId, pisCommonPaymentResponse);
        if (authorisationValidationResult.isNotValid()) {
            return authorisationValidationResult;
        }
        return ValidationResult.valid();
    }

    @ConstructorProperties(value={"pisEndpointAccessCheckerService", "requestProviderService", "pisAuthorisationValidator"})
    public UpdatePisCommonPaymentPsuDataValidator(PisEndpointAccessCheckerService pisEndpointAccessCheckerService, RequestProviderService requestProviderService, PisAuthorisationValidator pisAuthorisationValidator) {
        this.pisEndpointAccessCheckerService = pisEndpointAccessCheckerService;
        this.requestProviderService = requestProviderService;
        this.pisAuthorisationValidator = pisAuthorisationValidator;
    }
}

