/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.pis.authorisation.cancellation;

import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.pis.PaymentAuthorisationType;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.validator.PisEndpointAccessCheckerService;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.pis.AbstractPisTppValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.PisAuthorisationValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.cancellation.UpdatePisCancellationPsuDataPO;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UpdatePisCancellationPsuDataValidator
extends AbstractPisTppValidator<UpdatePisCancellationPsuDataPO> {
    private static final Logger log = LoggerFactory.getLogger(UpdatePisCancellationPsuDataValidator.class);
    private final PisEndpointAccessCheckerService pisEndpointAccessCheckerService;
    private final RequestProviderService requestProviderService;
    private final PisAuthorisationValidator pisAuthorisationValidator;

    @Override
    protected ValidationResult executeBusinessValidation(UpdatePisCancellationPsuDataPO paymentObject) {
        String authorisationId = paymentObject.getAuthorisationId();
        if (!this.pisEndpointAccessCheckerService.isEndpointAccessible(authorisationId, PaymentAuthorisationType.CANCELLED)) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Authorisation ID: [{}]. Updating PIS cancellation authorisation PSU Data has failed: endpoint is not accessible for authorisation", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), authorisationId});
            return ValidationResult.invalid(ErrorType.PIS_403, TppMessageInformation.of(MessageErrorCode.SERVICE_BLOCKED));
        }
        ValidationResult authorisationValidationResult = this.pisAuthorisationValidator.validate(authorisationId, paymentObject.getPisCommonPaymentResponse());
        if (authorisationValidationResult.isNotValid()) {
            return authorisationValidationResult;
        }
        return ValidationResult.valid();
    }

    @ConstructorProperties(value={"pisEndpointAccessCheckerService", "requestProviderService", "pisAuthorisationValidator"})
    public UpdatePisCancellationPsuDataValidator(PisEndpointAccessCheckerService pisEndpointAccessCheckerService, RequestProviderService requestProviderService, PisAuthorisationValidator pisAuthorisationValidator) {
        this.pisEndpointAccessCheckerService = pisEndpointAccessCheckerService;
        this.requestProviderService = requestProviderService;
        this.pisAuthorisationValidator = pisAuthorisationValidator;
    }
}

