/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.authorisation;

import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthorisationStatusValidator {
    private static final Logger log = LoggerFactory.getLogger(AuthorisationStatusValidator.class);
    private final RequestProviderService requestProviderService;

    @NotNull
    public ValidationResult validate(@NotNull ScaStatus scaStatus) {
        if (scaStatus == ScaStatus.FAILED) {
            log.info("InR-ID: [{}], X-Request-ID: [{}]. Authorisation has failed status", (Object)this.requestProviderService.getInternalRequestId(), (Object)this.requestProviderService.getRequestId());
            return ValidationResult.invalid(this.getErrorType(), MessageErrorCode.STATUS_INVALID);
        }
        return ValidationResult.valid();
    }

    @NotNull
    protected abstract ErrorType getErrorType();

    @ConstructorProperties(value={"requestProviderService"})
    public AuthorisationStatusValidator(RequestProviderService requestProviderService) {
        this.requestProviderService = requestProviderService;
    }
}

