/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.pis;

import de.adorsys.psd2.consent.api.pis.authorisation.CreatePisAuthorisationRequest;
import de.adorsys.psd2.consent.api.pis.authorisation.CreatePisAuthorisationResponse;
import de.adorsys.psd2.consent.api.pis.authorisation.GetPisAuthorisationResponse;
import de.adorsys.psd2.consent.api.pis.authorisation.UpdatePisCommonPaymentPsuDataRequest;
import de.adorsys.psd2.consent.api.service.PisCommonPaymentServiceEncrypted;
import de.adorsys.psd2.xs2a.config.factory.PisScaStageAuthorisationFactory;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.pis.PaymentAuthorisationType;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.AuthorisationScaApproachResponse;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import de.adorsys.psd2.xs2a.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataRequest;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataResponse;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.authorization.pis.stage.PisScaStage;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aPisCommonPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.web.mapper.TppRedirectUriMapper;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PisAuthorisationService {
    private static final Logger log = LoggerFactory.getLogger(PisAuthorisationService.class);
    private final PisCommonPaymentServiceEncrypted pisCommonPaymentServiceEncrypted;
    private final PisScaStageAuthorisationFactory pisScaStageAuthorisationFactory;
    private final Xs2aPisCommonPaymentMapper pisCommonPaymentMapper;
    private final ScaApproachResolver scaApproachResolver;
    private final RequestProviderService requestProviderService;
    private final TppRedirectUriMapper tppRedirectUriMapper;

    public CreatePisAuthorisationResponse createPisAuthorisation(String paymentId, PsuIdData psuData) {
        TppRedirectUri redirectURIs = this.tppRedirectUriMapper.mapToTppRedirectUri(this.requestProviderService.getTppRedirectURI(), this.requestProviderService.getTppNokRedirectURI());
        CreatePisAuthorisationRequest request = new CreatePisAuthorisationRequest(PaymentAuthorisationType.CREATED, psuData, this.scaApproachResolver.resolveScaApproach(), redirectURIs);
        return this.pisCommonPaymentServiceEncrypted.createAuthorization(paymentId, request).orElseGet(() -> {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment-ID [{}]. Create PIS authorisation has failed: can't save authorisation to cms DB", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), paymentId});
            return null;
        });
    }

    public Xs2aUpdatePisCommonPaymentPsuDataResponse updatePisAuthorisation(Xs2aUpdatePisCommonPaymentPsuDataRequest request, ScaApproach scaApproach) {
        String authorisationId = request.getAuthorisationId();
        Optional pisAuthorisationOptional = this.pisCommonPaymentServiceEncrypted.getPisAuthorisationById(authorisationId);
        if (!pisAuthorisationOptional.isPresent()) {
            ErrorHolder errorHolder = ErrorHolder.builder(ErrorType.PIS_404).tppMessages(TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404, "PIS authorisation is not found")).build();
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment-ID [{}], Authorisation-ID [{}]. Updating PIS authorisation PSU Data has failed: authorisation is not found by id.", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), request.getPaymentId(), request.getAuthorisationId()});
            return new Xs2aUpdatePisCommonPaymentPsuDataResponse(errorHolder, request.getPaymentId(), authorisationId, request.getPsuData());
        }
        GetPisAuthorisationResponse response = (GetPisAuthorisationResponse)pisAuthorisationOptional.get();
        PisScaStage service = (PisScaStage)this.pisScaStageAuthorisationFactory.getService(PisScaStageAuthorisationFactory.getServiceName(scaApproach, response.getScaStatus()));
        Xs2aUpdatePisCommonPaymentPsuDataResponse stageResponse = (Xs2aUpdatePisCommonPaymentPsuDataResponse)service.apply(request, response);
        if (stageResponse.hasError()) {
            log.warn("InR-ID: [{}], X-Request-ID: [{}], Payment-ID [{}], Authorisation-ID [{}]. Updating PIS authorisation PSU Data has failed. Error msg: [{}]", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), request.getPaymentId(), request.getAuthorisationId(), stageResponse.getErrorHolder()});
        } else {
            this.doUpdatePisAuthorisation(this.pisCommonPaymentMapper.mapToCmsUpdateCommonPaymentPsuDataReq(stageResponse));
        }
        return stageResponse;
    }

    public Xs2aUpdatePisCommonPaymentPsuDataResponse updatePisCancellationAuthorisation(Xs2aUpdatePisCommonPaymentPsuDataRequest request, ScaApproach scaApproach) {
        String authorisationId = request.getAuthorisationId();
        Optional pisCancellationAuthorisationOptional = this.pisCommonPaymentServiceEncrypted.getPisCancellationAuthorisationById(request.getAuthorisationId());
        if (!pisCancellationAuthorisationOptional.isPresent()) {
            log.warn("InR-ID: [{}], X-Request-ID: [{}], Payment-ID [{}], Authorisation-ID [{}]. Updating PIS Payment Cancellation authorisation PSU Data has failed: authorisation is not found by id.", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), request.getPaymentId(), request.getAuthorisationId()});
            ErrorHolder errorHolder = ErrorHolder.builder(ErrorType.PIS_404).tppMessages(TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404, "PIS cancellation authorisation is not found")).build();
            return new Xs2aUpdatePisCommonPaymentPsuDataResponse(errorHolder, request.getPaymentId(), authorisationId, request.getPsuData());
        }
        GetPisAuthorisationResponse response = (GetPisAuthorisationResponse)pisCancellationAuthorisationOptional.get();
        PisScaStage service = (PisScaStage)this.pisScaStageAuthorisationFactory.getService(PisScaStageAuthorisationFactory.getCancellationServiceName(scaApproach, response.getScaStatus()));
        Xs2aUpdatePisCommonPaymentPsuDataResponse stageResponse = (Xs2aUpdatePisCommonPaymentPsuDataResponse)service.apply(request, response);
        if (stageResponse.hasError()) {
            log.warn("InR-ID: [{}], X-Request-ID: [{}], Payment-ID [{}], Authorisation-ID [{}]. Updating PIS Payment Cancellation authorisation PSU Data has failed:. Error msg: [{}]", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), request.getPaymentId(), request.getAuthorisationId(), stageResponse.getErrorHolder()});
        } else {
            this.doUpdatePisCancellationAuthorisation(this.pisCommonPaymentMapper.mapToCmsUpdateCommonPaymentPsuDataReq(stageResponse));
        }
        return stageResponse;
    }

    public void doUpdatePisAuthorisation(UpdatePisCommonPaymentPsuDataRequest request) {
        this.pisCommonPaymentServiceEncrypted.updatePisAuthorisation(request.getAuthorizationId(), request);
    }

    public void doUpdatePisCancellationAuthorisation(UpdatePisCommonPaymentPsuDataRequest request) {
        this.pisCommonPaymentServiceEncrypted.updatePisCancellationAuthorisation(request.getAuthorizationId(), request);
    }

    public CreatePisAuthorisationResponse createPisAuthorisationCancellation(String paymentId, PsuIdData psuData) {
        TppRedirectUri redirectURIs = this.tppRedirectUriMapper.mapToTppRedirectUri(this.requestProviderService.getTppRedirectURI(), this.requestProviderService.getTppNokRedirectURI());
        CreatePisAuthorisationRequest request = new CreatePisAuthorisationRequest(PaymentAuthorisationType.CANCELLED, psuData, this.scaApproachResolver.resolveScaApproach(), redirectURIs);
        return this.pisCommonPaymentServiceEncrypted.createAuthorizationCancellation(paymentId, request).orElseGet(() -> {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment-ID [{}]. Create PIS Payment Cancellation Authorisation has failed. Can't find Payment Data by id or Payment is Finalised.", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), paymentId});
            return null;
        });
    }

    public Optional<List<String>> getCancellationAuthorisationSubResources(String paymentId) {
        return this.pisCommonPaymentServiceEncrypted.getAuthorisationsByPaymentId(paymentId, PaymentAuthorisationType.CANCELLED);
    }

    public Optional<List<String>> getAuthorisationSubResources(String paymentId) {
        return this.pisCommonPaymentServiceEncrypted.getAuthorisationsByPaymentId(paymentId, PaymentAuthorisationType.CREATED);
    }

    public Optional<ScaStatus> getAuthorisationScaStatus(String paymentId, String authorisationId) {
        return this.pisCommonPaymentServiceEncrypted.getAuthorisationScaStatus(paymentId, authorisationId, PaymentAuthorisationType.CREATED);
    }

    public Optional<ScaStatus> getCancellationAuthorisationScaStatus(String paymentId, String cancellationId) {
        return this.pisCommonPaymentServiceEncrypted.getAuthorisationScaStatus(paymentId, cancellationId, PaymentAuthorisationType.CANCELLED);
    }

    public Optional<AuthorisationScaApproachResponse> getAuthorisationScaApproach(String authorisationId, PaymentAuthorisationType authorisationType) {
        return this.pisCommonPaymentServiceEncrypted.getAuthorisationScaApproach(authorisationId, authorisationType);
    }

    @ConstructorProperties(value={"pisCommonPaymentServiceEncrypted", "pisScaStageAuthorisationFactory", "pisCommonPaymentMapper", "scaApproachResolver", "requestProviderService", "tppRedirectUriMapper"})
    public PisAuthorisationService(PisCommonPaymentServiceEncrypted pisCommonPaymentServiceEncrypted, PisScaStageAuthorisationFactory pisScaStageAuthorisationFactory, Xs2aPisCommonPaymentMapper pisCommonPaymentMapper, ScaApproachResolver scaApproachResolver, RequestProviderService requestProviderService, TppRedirectUriMapper tppRedirectUriMapper) {
        this.pisCommonPaymentServiceEncrypted = pisCommonPaymentServiceEncrypted;
        this.pisScaStageAuthorisationFactory = pisScaStageAuthorisationFactory;
        this.pisCommonPaymentMapper = pisCommonPaymentMapper;
        this.scaApproachResolver = scaApproachResolver;
        this.requestProviderService = requestProviderService;
        this.tppRedirectUriMapper = tppRedirectUriMapper;
    }
}

