/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.consent.api.ActionStatus;
import de.adorsys.psd2.consent.api.TypeAccess;
import de.adorsys.psd2.event.core.model.EventType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.error.TppMessage;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.Transactions;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsDownloadResponse;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsReportByPeriodRequest;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccess;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.AccountService;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAccountReferenceMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aBalanceMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aDownloadTransactionsMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aTransactionMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiTransactionListToXs2aAccountReportMapper;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.ValueValidatorService;
import de.adorsys.psd2.xs2a.service.validator.ais.account.DownloadTransactionsReportValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.GetTransactionDetailsValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.GetTransactionsReportValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.CommonAccountTransactionsRequestObject;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.DownloadTransactionListRequestObject;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.TransactionsReportByPeriodObject;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransaction;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransactionReport;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransactionsDownloadResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.AccountSpi;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Base64;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.validation.annotation.Validated;

@Service
@Validated
public class TransactionService {
    private static final Logger log = LoggerFactory.getLogger(TransactionService.class);
    private final AccountSpi accountSpi;
    private final AccountService accountService;
    private final SpiToXs2aBalanceMapper balanceMapper;
    private final SpiToXs2aAccountReferenceMapper referenceMapper;
    private final SpiTransactionListToXs2aAccountReportMapper transactionsToAccountReportMapper;
    private final SpiToXs2aTransactionMapper spiToXs2aTransactionMapper;
    private final SpiToXs2aDownloadTransactionsMapper spiToXs2aDownloadTransactionsMapper;
    private final ValueValidatorService validatorService;
    private final Xs2aAisConsentService aisConsentService;
    private final Xs2aAisConsentMapper consentMapper;
    private final TppService tppService;
    private final AspspProfileServiceWrapper aspspProfileService;
    private final Xs2aEventService xs2aEventService;
    private final SpiContextDataProvider spiContextDataProvider;
    private final SpiErrorMapper spiErrorMapper;
    private final GetTransactionsReportValidator getTransactionsReportValidator;
    private final DownloadTransactionsReportValidator downloadTransactionsReportValidator;
    private final GetTransactionDetailsValidator getTransactionDetailsValidator;
    private final RequestProviderService requestProviderService;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;

    public ResponseObject<Xs2aTransactionsReport> getTransactionsReportByPeriod(Xs2aTransactionsReportByPeriodRequest request) {
        String consentId = request.getConsentId();
        String accountId = request.getAccountId();
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.READ_TRANSACTION_LIST_REQUEST_RECEIVED);
        Optional<AccountConsent> accountConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        UUID xRequestId = this.requestProviderService.getRequestId();
        UUID internalRequestId = this.requestProviderService.getInternalRequestId();
        if (!accountConsentOptional.isPresent()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Account-ID [{}], Consent-ID [{}]. Get transactions report by period failed. Account consent not found by id", new Object[]{internalRequestId, xRequestId, accountId, consentId});
            return ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_400)).build();
        }
        String requestUri = request.getRequestUri();
        boolean withBalance = request.isWithBalance();
        AccountConsent accountConsent = accountConsentOptional.get();
        TransactionsReportByPeriodObject validatorObject = new TransactionsReportByPeriodObject(accountConsent, accountId, withBalance, requestUri, request.getEntryReferenceFrom(), request.getDeltaList(), request.getAcceptHeader(), request.getBookingStatus());
        ValidationResult validationResult = this.getTransactionsReportValidator.validate(validatorObject);
        if (validationResult.isNotValid()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Account-ID [{}], Consent-ID [{}], WithBalance [{}], RequestUri [{}]. Get transactions report by period - validation failed: {}", new Object[]{internalRequestId, xRequestId, accountId, consentId, withBalance, requestUri, validationResult.getMessageError()});
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        Xs2aAccountAccess access = accountConsent.getAccess();
        SpiAccountReference requestedAccountReference = this.accountService.findAccountReference(access.getAllPsd2(), access.getTransactions(), accountId);
        LocalDate dateFrom = request.getDateFrom();
        LocalDate dateTo = request.getDateTo();
        LocalDate dateToChecked = Optional.ofNullable(dateTo).orElseGet(LocalDate::now);
        this.validatorService.validateAccountIdPeriod(accountId, dateFrom, dateToChecked);
        boolean isTransactionsShouldContainBalances = !this.aspspProfileService.isTransactionsWithoutBalancesSupported() || withBalance;
        SpiContextData contextData = this.getSpiContextData();
        SpiAspspConsentDataProvider aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId);
        SpiResponse spiResponse = this.accountSpi.requestTransactionsForAccount(contextData, request.getAcceptHeader(), isTransactionsShouldContainBalances, dateFrom, dateToChecked, request.getBookingStatus(), requestedAccountReference, this.consentMapper.mapToSpiAccountConsent(accountConsent), aspspConsentDataProvider);
        if (spiResponse.hasError()) {
            if (((TppMessage)spiResponse.getErrors().get(0)).getErrorCode() == MessageErrorCode.SERVICE_NOT_SUPPORTED) {
                log.info("InR-ID: [{}], X-Request-ID: [{}], Account-ID [{}], Consent-ID: [{}]. Get transactions report by period failed: requested content-type not json or text.", new Object[]{internalRequestId, xRequestId, accountId, consentId});
                return ResponseObject.builder().fail(ErrorType.AIS_406, TppMessageInformation.of(MessageErrorCode.REQUESTED_FORMATS_INVALID)).build();
            }
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS);
            log.info("InR-ID: [{}], X-Request-ID: [{}], Account-ID [{}], Consent-ID: [{}]. Get transactions report by period failed: Request transactions for account fail at SPI level: {}", new Object[]{internalRequestId, xRequestId, accountId, consentId, errorHolder});
            return ResponseObject.builder().fail(errorHolder).build();
        }
        SpiTransactionReport spiTransactionReport = (SpiTransactionReport)spiResponse.getPayload();
        if (spiTransactionReport == null) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Account-ID [{}], Consent-ID: [{}]. Get transactions report by period failed: transactions empty for account.", new Object[]{internalRequestId, xRequestId, accountId, consentId});
            return ResponseObject.builder().fail(ErrorType.AIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404)).build();
        }
        Optional<Xs2aAccountReport> report = this.transactionsToAccountReportMapper.mapToXs2aAccountReport(spiTransactionReport.getTransactions(), spiTransactionReport.getTransactionsRaw());
        Xs2aTransactionsReport transactionsReport = new Xs2aTransactionsReport();
        transactionsReport.setAccountReport(report.orElse(null));
        transactionsReport.setAccountReference(this.referenceMapper.mapToXs2aAccountReference(requestedAccountReference));
        transactionsReport.setBalances(this.balanceMapper.mapToXs2aBalanceList(spiTransactionReport.getBalances()));
        transactionsReport.setResponseContentType(spiTransactionReport.getResponseContentType());
        if (spiTransactionReport.getDownloadId() != null) {
            String encodedDownloadId = Base64.getUrlEncoder().encodeToString(spiTransactionReport.getDownloadId().getBytes());
            transactionsReport.setDownloadId(encodedDownloadId);
        }
        ResponseObject<Xs2aTransactionsReport> response = ResponseObject.builder().body(transactionsReport).build();
        this.aisConsentService.consentActionLog(this.tppService.getTppId(), consentId, this.createActionStatus(withBalance, response), requestUri, this.needsToUpdateUsage(accountConsent));
        return response;
    }

    public ResponseObject<Transactions> getTransactionDetails(String consentId, String accountId, String transactionId, String requestUri) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.READ_TRANSACTION_DETAILS_REQUEST_RECEIVED);
        Optional<AccountConsent> accountConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        UUID internalRequestId = this.requestProviderService.getInternalRequestId();
        UUID xRequestId = this.requestProviderService.getRequestId();
        if (!accountConsentOptional.isPresent()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Account-ID [{}], Consent-ID [{}]. Get transaction details failed. Account consent not found by ID", new Object[]{internalRequestId, xRequestId, accountId, consentId});
            return ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_400)).build();
        }
        AccountConsent accountConsent = accountConsentOptional.get();
        ValidationResult validationResult = this.getTransactionDetailsValidator.validate(new CommonAccountTransactionsRequestObject(accountConsent, accountId, requestUri));
        if (validationResult.isNotValid()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Account-ID [{}], Consent-ID [{}], RequestUri [{}]. Get transaction details - validation failed: {}", new Object[]{internalRequestId, xRequestId, accountId, consentId, requestUri, validationResult.getMessageError()});
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        Xs2aAccountAccess access = accountConsent.getAccess();
        SpiAccountReference requestedAccountReference = this.accountService.findAccountReference(access.getAllPsd2(), access.getTransactions(), accountId);
        this.validatorService.validateAccountIdTransactionId(accountId, transactionId);
        SpiContextData contextData = this.getSpiContextData();
        SpiAspspConsentDataProvider aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId);
        SpiResponse spiResponse = this.accountSpi.requestTransactionForAccountByTransactionId(contextData, transactionId, requestedAccountReference, this.consentMapper.mapToSpiAccountConsent(accountConsent), aspspConsentDataProvider);
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS);
            log.info("InR-ID: [{}], X-Request-ID: [{}], Account-ID [{}], Consent-ID: [{}]. Get transaction details failed: Request transactions for account fail at SPI level: {}", new Object[]{internalRequestId, xRequestId, accountId, consentId, errorHolder});
            return ResponseObject.builder().fail(new MessageError(errorHolder)).build();
        }
        SpiTransaction payload = (SpiTransaction)spiResponse.getPayload();
        if (payload == null) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Account-ID [{}], Consent-ID: [{}]. Get transaction details failed: transaction details empty for account and transaction.", new Object[]{internalRequestId, xRequestId, accountId, consentId});
            return ResponseObject.builder().fail(ErrorType.AIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404)).build();
        }
        Transactions transactions = this.spiToXs2aTransactionMapper.mapToXs2aTransaction(payload);
        ResponseObject<Transactions> response = ResponseObject.builder().body(transactions).build();
        this.aisConsentService.consentActionLog(this.tppService.getTppId(), consentId, this.createActionStatus(false, response), requestUri, this.needsToUpdateUsage(accountConsent));
        return response;
    }

    public ResponseObject<Xs2aTransactionsDownloadResponse> downloadTransactions(String consentId, String accountId, String downloadId) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.DOWNLOAD_TRANSACTION_LIST_REQUEST_RECEIVED);
        Optional<AccountConsent> accountConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        UUID internalRequestId = this.requestProviderService.getInternalRequestId();
        UUID xRequestId = this.requestProviderService.getRequestId();
        if (!accountConsentOptional.isPresent()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Consent-ID [{}], Account-ID: [{}], Download-ID: [{}]. Download transactions failed. Account consent not found by ID", new Object[]{internalRequestId, xRequestId, consentId, accountId, downloadId});
            return ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_400)).build();
        }
        AccountConsent accountConsent = accountConsentOptional.get();
        ValidationResult validationResult = this.downloadTransactionsReportValidator.validate(new DownloadTransactionListRequestObject(accountConsent));
        if (validationResult.isNotValid()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Consent-ID [{}], Account-ID: [{}], Download-ID: [{}]. Download transactions - validation failed: {}", new Object[]{internalRequestId, xRequestId, consentId, accountId, downloadId, validationResult.getMessageError()});
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        String decodedDownloadId = new String(Base64.getUrlDecoder().decode(downloadId));
        SpiContextData contextData = this.getSpiContextData();
        SpiAspspConsentDataProvider aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId);
        SpiResponse spiResponse = this.accountSpi.requestTransactionsByDownloadLink(contextData, this.consentMapper.mapToSpiAccountConsent(accountConsent), decodedDownloadId, aspspConsentDataProvider);
        if (spiResponse.hasError()) {
            log.info("X-Request-ID: [{}], Consent-ID [{}], Account-ID: [{}], Download-ID: [{}]. Download transactions failed: couldn't get download transactions stream by link.", new Object[]{xRequestId, consentId, accountId, downloadId});
            return ResponseObject.builder().fail(new MessageError(this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS))).build();
        }
        if (spiResponse.getPayload() == null) {
            log.info("X-Request-ID: [{}], Consent-ID [{}], Account-ID: [{}], Download-ID: [{}]. Download transactions failed: spiResponse is empty.", new Object[]{xRequestId, consentId, accountId, downloadId});
            return ResponseObject.builder().fail(ErrorType.AIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404)).build();
        }
        SpiTransactionsDownloadResponse spiPayload = (SpiTransactionsDownloadResponse)spiResponse.getPayload();
        return ResponseObject.builder().body(this.spiToXs2aDownloadTransactionsMapper.mapToXs2aTransactionsDownloadResponse(spiPayload)).build();
    }

    private boolean needsToUpdateUsage(AccountConsent accountConsent) {
        return accountConsent.isOneAccessType() || this.requestProviderService.isRequestFromTPP();
    }

    private SpiContextData getSpiContextData() {
        PsuIdData psuIdData = this.requestProviderService.getPsuIdData();
        log.info("X-Request-ID: [{}]. Corresponding PSU-ID {} was provided from request.", (Object)this.requestProviderService.getRequestId(), (Object)psuIdData);
        return this.spiContextDataProvider.provideWithPsuIdData(psuIdData);
    }

    private ActionStatus createActionStatus(boolean withBalance, ResponseObject response) {
        return response.hasError() ? this.consentMapper.mapActionStatusError(response.getError().getTppMessage().getMessageErrorCode(), withBalance, TypeAccess.TRANSACTION) : ActionStatus.SUCCESS;
    }

    @ConstructorProperties(value={"accountSpi", "accountService", "balanceMapper", "referenceMapper", "transactionsToAccountReportMapper", "spiToXs2aTransactionMapper", "spiToXs2aDownloadTransactionsMapper", "validatorService", "aisConsentService", "consentMapper", "tppService", "aspspProfileService", "xs2aEventService", "spiContextDataProvider", "spiErrorMapper", "getTransactionsReportValidator", "downloadTransactionsReportValidator", "getTransactionDetailsValidator", "requestProviderService", "aspspConsentDataProviderFactory"})
    public TransactionService(AccountSpi accountSpi, AccountService accountService, SpiToXs2aBalanceMapper balanceMapper, SpiToXs2aAccountReferenceMapper referenceMapper, SpiTransactionListToXs2aAccountReportMapper transactionsToAccountReportMapper, SpiToXs2aTransactionMapper spiToXs2aTransactionMapper, SpiToXs2aDownloadTransactionsMapper spiToXs2aDownloadTransactionsMapper, ValueValidatorService validatorService, Xs2aAisConsentService aisConsentService, Xs2aAisConsentMapper consentMapper, TppService tppService, AspspProfileServiceWrapper aspspProfileService, Xs2aEventService xs2aEventService, SpiContextDataProvider spiContextDataProvider, SpiErrorMapper spiErrorMapper, GetTransactionsReportValidator getTransactionsReportValidator, DownloadTransactionsReportValidator downloadTransactionsReportValidator, GetTransactionDetailsValidator getTransactionDetailsValidator, RequestProviderService requestProviderService, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory) {
        this.accountSpi = accountSpi;
        this.accountService = accountService;
        this.balanceMapper = balanceMapper;
        this.referenceMapper = referenceMapper;
        this.transactionsToAccountReportMapper = transactionsToAccountReportMapper;
        this.spiToXs2aTransactionMapper = spiToXs2aTransactionMapper;
        this.spiToXs2aDownloadTransactionsMapper = spiToXs2aDownloadTransactionsMapper;
        this.validatorService = validatorService;
        this.aisConsentService = aisConsentService;
        this.consentMapper = consentMapper;
        this.tppService = tppService;
        this.aspspProfileService = aspspProfileService;
        this.xs2aEventService = xs2aEventService;
        this.spiContextDataProvider = spiContextDataProvider;
        this.spiErrorMapper = spiErrorMapper;
        this.getTransactionsReportValidator = getTransactionsReportValidator;
        this.downloadTransactionsReportValidator = downloadTransactionsReportValidator;
        this.getTransactionDetailsValidator = getTransactionDetailsValidator;
        this.requestProviderService = requestProviderService;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
    }
}

