/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.event.core.model.EventType;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.authorisation.AuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsentAuthorization;
import de.adorsys.psd2.xs2a.domain.consent.ConsentStatusResponse;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentAuthorizationResponse;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentResponse;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccess;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthorisationSubResources;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.authorization.AuthorisationMethodDecider;
import de.adorsys.psd2.xs2a.service.authorization.ais.AisAuthorizationService;
import de.adorsys.psd2.xs2a.service.authorization.ais.AisScaAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.ais.AisScaAuthorisationServiceResolver;
import de.adorsys.psd2.xs2a.service.consent.AccountReferenceInConsentUpdater;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAccountAccessMapper;
import de.adorsys.psd2.xs2a.service.spi.InitialSpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.service.validator.AisEndpointAccessCheckerService;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.ais.CommonConsentObject;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.CreateConsentAuthorisationValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.CreateConsentRequestValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.DeleteAccountConsentsByIdValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.GetAccountConsentByIdValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.GetAccountConsentsStatusByIdValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.GetConsentAuthorisationScaStatusValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.GetConsentAuthorisationsValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.UpdateConsentPsuDataValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.dto.CreateConsentRequestObject;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.dto.UpdateConsentPsuDataRequestObject;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountConsent;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiAisConsentStatusResponse;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiInitiateAisConsentResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.AisConsentSpi;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ConsentService {
    private static final Logger log = LoggerFactory.getLogger(ConsentService.class);
    private final Xs2aAisConsentMapper aisConsentMapper;
    private final SpiToXs2aAccountAccessMapper spiToXs2aAccountAccessMapper;
    private final Xs2aAisConsentService aisConsentService;
    private final AisScaAuthorisationServiceResolver aisScaAuthorisationServiceResolver;
    private final TppService tppService;
    private final AisEndpointAccessCheckerService endpointAccessCheckerService;
    private final SpiContextDataProvider spiContextDataProvider;
    private final AuthorisationMethodDecider authorisationMethodDecider;
    private final AisConsentSpi aisConsentSpi;
    private final Xs2aEventService xs2aEventService;
    private final AccountReferenceInConsentUpdater accountReferenceUpdater;
    private final SpiErrorMapper spiErrorMapper;
    private final CreateConsentRequestValidator createConsentRequestValidator;
    private final GetAccountConsentsStatusByIdValidator getAccountConsentsStatusByIdValidator;
    private final GetAccountConsentByIdValidator getAccountConsentByIdValidator;
    private final DeleteAccountConsentsByIdValidator deleteAccountConsentsByIdValidator;
    private final CreateConsentAuthorisationValidator createConsentAuthorisationValidator;
    private final UpdateConsentPsuDataValidator updateConsentPsuDataValidator;
    private final GetConsentAuthorisationsValidator getConsentAuthorisationsValidator;
    private final GetConsentAuthorisationScaStatusValidator getConsentAuthorisationScaStatusValidator;
    private final AisScaAuthorisationService aisScaAuthorisationService;
    private final RequestProviderService requestProviderService;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;

    public ResponseObject<CreateConsentResponse> createAccountConsentsWithResponse(CreateConsentReq request, PsuIdData psuData, boolean explicitPreferred) {
        TppInfo tppInfo;
        String consentId;
        this.xs2aEventService.recordTppRequest(EventType.CREATE_AIS_CONSENT_REQUEST_RECEIVED, request);
        ValidationResult validationResult = this.createConsentRequestValidator.validate(new CreateConsentRequestObject(request, psuData));
        if (validationResult.isNotValid()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}]. Create account consent with response - validation failed: {}", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), validationResult.getMessageError()});
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        if (request.isGlobalOrAllAccountsAccessConsent()) {
            request.setAccess(this.getAccessForGlobalOrAllAvailableAccountsConsent(request));
        }
        if (StringUtils.isBlank((CharSequence)(consentId = this.aisConsentService.createConsent(request, psuData, tppInfo = this.tppService.getTppInfo())))) {
            return ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_400)).build();
        }
        Optional<AccountConsent> accountConsentOptional = this.aisConsentService.getInitialAccountConsentById(consentId);
        if (!accountConsentOptional.isPresent()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Consent-ID: [{}]. Create account consent  with response failed: Actual consent not found by id", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), consentId});
            return ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_400)).build();
        }
        SpiContextData contextData = this.spiContextDataProvider.provide(psuData, tppInfo);
        InitialSpiAspspConsentDataProvider aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getInitialAspspConsentDataProvider();
        aspspConsentDataProvider.saveWith(consentId);
        SpiResponse initiateAisConsentSpiResponse = this.aisConsentSpi.initiateAisConsent(contextData, this.aisConsentMapper.mapToSpiAccountConsent(accountConsentOptional.get()), (SpiAspspConsentDataProvider)aspspConsentDataProvider);
        if (initiateAisConsentSpiResponse.hasError()) {
            this.aisConsentService.updateConsentStatus(consentId, ConsentStatus.REJECTED);
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(initiateAisConsentSpiResponse, ServiceType.AIS);
            log.info("InR-ID: [{}], X-Request-ID: [{}], Consent-ID: [{}]. Create account consent  with response failed. Consent rejected. Couldn't initiate AIS consent at SPI level: {}", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), consentId, errorHolder});
            return ResponseObject.builder().fail(new MessageError(errorHolder)).build();
        }
        SpiInitiateAisConsentResponse spiResponsePayload = (SpiInitiateAisConsentResponse)initiateAisConsentSpiResponse.getPayload();
        boolean multilevelScaRequired = spiResponsePayload.isMultilevelScaRequired() && !this.aisScaAuthorisationService.isOneFactorAuthorisation(request.isConsentForAllAvailableAccounts(), request.isOneAccessType());
        this.updateMultilevelSca(consentId, multilevelScaRequired);
        Optional<Xs2aAccountAccess> xs2aAccountAccess = this.spiToXs2aAccountAccessMapper.mapToAccountAccess(spiResponsePayload.getAccountAccess());
        xs2aAccountAccess.ifPresent(accountAccess -> this.accountReferenceUpdater.rewriteAccountAccess(consentId, (Xs2aAccountAccess)accountAccess));
        CreateConsentResponse createConsentResponse = new CreateConsentResponse(ConsentStatus.RECEIVED.getValue(), consentId, null, null, null, spiResponsePayload.getPsuMessage(), multilevelScaRequired);
        ResponseObject<CreateConsentResponse> createConsentResponseObject = ResponseObject.builder().body(createConsentResponse).build();
        if (this.authorisationMethodDecider.isImplicitMethod(explicitPreferred, multilevelScaRequired)) {
            this.proceedImplicitCaseForCreateConsent(createConsentResponseObject.getBody(), psuData, consentId);
        }
        return createConsentResponseObject;
    }

    private void updateMultilevelSca(String consentId, boolean multilevelScaRequired) {
        if (multilevelScaRequired) {
            this.aisConsentService.updateMultilevelScaRequired(consentId, multilevelScaRequired);
        }
    }

    public ResponseObject<ConsentStatusResponse> getAccountConsentsStatusById(String consentId) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.GET_AIS_CONSENT_STATUS_REQUEST_RECEIVED);
        ResponseObject.ResponseBuilder<ConsentStatusResponse> responseBuilder = ResponseObject.builder();
        Optional<AccountConsent> validatedAccountConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        if (!validatedAccountConsentOptional.isPresent()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Consent-ID: [{}]. Get account consents status failed: consent not found by id", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), consentId});
            return responseBuilder.fail(ErrorType.AIS_403, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_403)).build();
        }
        AccountConsent validatedAccountConsent = validatedAccountConsentOptional.get();
        ValidationResult validationResult = this.getAccountConsentsStatusByIdValidator.validate(new CommonConsentObject(validatedAccountConsent));
        if (validationResult.isNotValid()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}]. Create account consents status - validation failed: {}", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), validationResult.getMessageError()});
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        ConsentStatus consentStatus = validatedAccountConsent.getConsentStatus();
        if (consentStatus.isFinalisedStatus()) {
            return responseBuilder.body(new ConsentStatusResponse(consentStatus)).build();
        }
        SpiResponse<SpiAisConsentStatusResponse> spiResponse = this.getConsentStatusFromSpi(validatedAccountConsent, consentId);
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS);
            log.info("InR-ID: [{}], X-Request-ID: [{}]. Get account consents status failed: Couldn't get AIS consent status at SPI level: {}", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), errorHolder});
            return responseBuilder.fail(new MessageError(errorHolder)).build();
        }
        ConsentStatus spiConsentStatus = ((SpiAisConsentStatusResponse)spiResponse.getPayload()).getConsentStatus();
        this.aisConsentService.updateConsentStatus(consentId, spiConsentStatus);
        return responseBuilder.body(new ConsentStatusResponse(spiConsentStatus)).build();
    }

    public ResponseObject<Void> deleteAccountConsentsById(String consentId) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.DELETE_AIS_CONSENT_REQUEST_RECEIVED);
        Optional<AccountConsent> accountConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        if (accountConsentOptional.isPresent()) {
            AccountConsent accountConsent = accountConsentOptional.get();
            ValidationResult validationResult = this.deleteAccountConsentsByIdValidator.validate(new CommonConsentObject(accountConsent));
            if (validationResult.isNotValid()) {
                log.info("InR-ID: [{}], X-Request-ID: [{}], Consent-ID: [{}]. Delete account consent - validation failed: {}", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), accountConsent.getId(), validationResult.getMessageError()});
                return ResponseObject.builder().fail(validationResult.getMessageError()).build();
            }
            SpiContextData contextData = this.getSpiContextData();
            SpiAspspConsentDataProvider aspspDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId);
            SpiResponse revokeAisConsentResponse = this.aisConsentSpi.revokeAisConsent(contextData, this.aisConsentMapper.mapToSpiAccountConsent(accountConsent), aspspDataProvider);
            if (revokeAisConsentResponse.hasError()) {
                ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(revokeAisConsentResponse, ServiceType.AIS);
                log.info("InR-ID: [{}], X-Request-ID: [{}], Consent-ID: [{}]. Delete account consent failed: Couldn't revoke AIS consent at SPI level: {}", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), accountConsent.getId(), errorHolder});
                return ResponseObject.builder().fail(new MessageError(errorHolder)).build();
            }
            ConsentStatus newConsentStatus = accountConsent.getConsentStatus() == ConsentStatus.RECEIVED ? ConsentStatus.REJECTED : ConsentStatus.TERMINATED_BY_TPP;
            this.aisConsentService.updateConsentStatus(consentId, newConsentStatus);
            return ResponseObject.builder().build();
        }
        log.info("InR-ID: [{}], X-Request-ID: [{}], Consent-ID: [{}]. Delete account consent failed: consent not found by id", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), consentId});
        return ResponseObject.builder().fail(ErrorType.AIS_403, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_403)).build();
    }

    public ResponseObject<AccountConsent> getAccountConsentById(String consentId) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.GET_AIS_CONSENT_REQUEST_RECEIVED);
        Optional<AccountConsent> consentOptional = this.aisConsentService.getAccountConsentById(consentId);
        if (!consentOptional.isPresent()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Consent-ID: [{}]. Get account consent failed: initial consent not found by id", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), consentId});
            return ResponseObject.builder().fail(ErrorType.AIS_403, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_403)).build();
        }
        AccountConsent consent = consentOptional.get();
        ValidationResult validationResult = this.getAccountConsentByIdValidator.validate(new CommonConsentObject(consent));
        if (validationResult.isNotValid()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Consent-ID: [{}]. Get account consent - validation failed: {}", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), consentId, validationResult.getMessageError()});
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        if (Objects.nonNull(consent.getConsentStatus()) && consent.getConsentStatus().isFinalisedStatus()) {
            return ResponseObject.builder().body(consent).build();
        }
        SpiResponse<SpiAisConsentStatusResponse> spiConsentStatus = this.getConsentStatusFromSpi(consent, consentId);
        if (spiConsentStatus.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiConsentStatus, ServiceType.AIS);
            log.info("InR-ID: [{}], X-Request-ID: [{}]. Get account consents failed: Couldn't get AIS consent at SPI level: {}", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), errorHolder});
            return ResponseObject.builder().fail(new MessageError(errorHolder)).build();
        }
        ConsentStatus consentStatus = ((SpiAisConsentStatusResponse)spiConsentStatus.getPayload()).getConsentStatus();
        this.aisConsentService.updateConsentStatus(consentId, consentStatus);
        return ResponseObject.builder().body(this.aisConsentMapper.mapToAccountConsentWithNewStatus(consent, consentStatus)).build();
    }

    public ResponseObject<AuthorisationResponse> createAisAuthorisation(PsuIdData psuData, String consentId, String password) {
        ResponseObject<CreateConsentAuthorizationResponse> createAisAuthorizationResponse = this.createConsentAuthorizationWithResponse(psuData, consentId);
        if (createAisAuthorizationResponse.hasError()) {
            return ResponseObject.builder().fail(createAisAuthorizationResponse.getError()).build();
        }
        if (psuData.isEmpty() || StringUtils.isBlank((CharSequence)password)) {
            return ResponseObject.builder().body(createAisAuthorizationResponse.getBody()).build();
        }
        String authorisationId = createAisAuthorizationResponse.getBody().getAuthorisationId();
        UpdateConsentPsuDataReq updatePsuData = new UpdateConsentPsuDataReq();
        updatePsuData.setPsuData(psuData);
        updatePsuData.setConsentId(consentId);
        updatePsuData.setAuthorizationId(authorisationId);
        updatePsuData.setPassword(password);
        ResponseObject<UpdateConsentPsuDataResponse> updatePsuDataResponse = this.updateConsentPsuData(updatePsuData);
        if (updatePsuDataResponse.hasError()) {
            return ResponseObject.builder().fail(updatePsuDataResponse.getError()).build();
        }
        return ResponseObject.builder().body(updatePsuDataResponse.getBody()).build();
    }

    private ResponseObject<CreateConsentAuthorizationResponse> createConsentAuthorizationWithResponse(PsuIdData psuData, String consentId) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.START_AIS_CONSENT_AUTHORISATION_REQUEST_RECEIVED);
        Optional<AccountConsent> accountConsent = this.aisConsentService.getAccountConsentById(consentId);
        if (!accountConsent.isPresent()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Consent-ID: [{}]. Create consent authorisation with response failed: consent not found by id", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), consentId});
            return ResponseObject.builder().fail(ErrorType.AIS_403, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_403)).build();
        }
        ValidationResult validationResult = this.createConsentAuthorisationValidator.validate(new CommonConsentObject(accountConsent.get()));
        if (validationResult.isNotValid()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Consent-ID: [{}]. Create consent authorisation with response - validation failed: {}", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), consentId, validationResult.getMessageError()});
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        if (accountConsent.get().isExpired()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Consent-ID: [{}]. Create consent authorisation with response failed: consent expired", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), consentId});
            return ResponseObject.builder().fail(ErrorType.AIS_401, TppMessageInformation.of(MessageErrorCode.CONSENT_EXPIRED)).build();
        }
        AisAuthorizationService service = (AisAuthorizationService)this.aisScaAuthorisationServiceResolver.getService();
        return service.createConsentAuthorization(psuData, consentId).map(resp -> ResponseObject.builder().body((CreateConsentAuthorizationResponse)resp).build()).orElseGet(ResponseObject.builder().fail(ErrorType.AIS_403, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_403))::build);
    }

    public ResponseObject<UpdateConsentPsuDataResponse> updateConsentPsuData(UpdateConsentPsuDataReq updatePsuData) {
        this.xs2aEventService.recordAisTppRequest(updatePsuData.getConsentId(), EventType.UPDATE_AIS_CONSENT_PSU_DATA_REQUEST_RECEIVED, updatePsuData);
        String consentId = updatePsuData.getConsentId();
        String authorisationId = updatePsuData.getAuthorizationId();
        if (!this.endpointAccessCheckerService.isEndpointAccessible(authorisationId, consentId)) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Consent-ID: [{}], Authorisation-ID [{}]. Update consent PSU data failed: update endpoint is blocked for current authorisation", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), consentId, authorisationId});
            return ResponseObject.builder().fail(ErrorType.AIS_403, TppMessageInformation.of(MessageErrorCode.SERVICE_BLOCKED)).build();
        }
        Optional<AccountConsent> accountConsent = this.aisConsentService.getAccountConsentById(consentId);
        if (!accountConsent.isPresent()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Consent-ID: [{}]. Update consent PSU data failed: consent not found by id", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), consentId});
            return ResponseObject.builder().fail(ErrorType.AIS_403, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_403)).build();
        }
        Optional<AccountConsentAuthorization> authorisationOptional = ((AisAuthorizationService)this.aisScaAuthorisationServiceResolver.getServiceInitiation(updatePsuData.getAuthorizationId())).getAccountConsentAuthorizationById(updatePsuData.getAuthorizationId(), updatePsuData.getConsentId());
        if (!authorisationOptional.isPresent()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Consent-ID: [{}], Authorisation-ID: [{}]. Update consent PSU data failed: authorisation not found by id", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), consentId, authorisationId});
            return ResponseObject.builder().fail(ErrorType.AIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404)).build();
        }
        AccountConsentAuthorization authorisation = authorisationOptional.get();
        ValidationResult validationResult = this.updateConsentPsuDataValidator.validate(new UpdateConsentPsuDataRequestObject(accountConsent.get(), authorisation));
        if (validationResult.isNotValid()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Consent-ID: [{}], Authorisation-ID [{}]. Update consent PSU data - validation failed: {}", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), consentId, authorisationId, validationResult.getMessageError()});
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        if (accountConsent.get().isExpired()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Consent-ID: [{}]. Update consent PSU data failed: consent expired", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), consentId});
            return ResponseObject.builder().fail(ErrorType.AIS_401, TppMessageInformation.of(MessageErrorCode.CONSENT_EXPIRED)).build();
        }
        return this.getUpdateConsentPsuDataResponse(updatePsuData, authorisation);
    }

    private ResponseObject<UpdateConsentPsuDataResponse> getUpdateConsentPsuDataResponse(UpdateConsentPsuDataReq updatePsuData, AccountConsentAuthorization consentAuthorization) {
        UpdateConsentPsuDataResponse response = ((AisAuthorizationService)this.aisScaAuthorisationServiceResolver.getServiceInitiation(updatePsuData.getAuthorizationId())).updateConsentPsuData(updatePsuData, consentAuthorization);
        return Optional.ofNullable(response).map(s -> Optional.ofNullable(s.getMessageError()).map(e -> ResponseObject.builder().fail((MessageError)e).build()).orElseGet(ResponseObject.builder().body(response)::build)).orElseGet(ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR))::build);
    }

    public ResponseObject<Xs2aAuthorisationSubResources> getConsentInitiationAuthorisations(String consentId) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.GET_CONSENT_AUTHORISATION_REQUEST_RECEIVED);
        Optional<AccountConsent> accountConsent = this.aisConsentService.getAccountConsentById(consentId);
        if (!accountConsent.isPresent()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Consent-ID: [{}]. Get consent initiation authorisations failed: consent not found by id", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), consentId});
            return ResponseObject.builder().fail(ErrorType.AIS_403, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_403)).build();
        }
        ValidationResult validationResult = this.getConsentAuthorisationsValidator.validate(new CommonConsentObject(accountConsent.get()));
        if (validationResult.isNotValid()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Consent-ID: [{}]. Get consent authorisations - validation failed: {}", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), consentId, validationResult.getMessageError()});
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        return this.getAuthorisationSubResources(consentId).map(resp -> ResponseObject.builder().body((Xs2aAuthorisationSubResources)resp).build()).orElseGet(() -> {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Consent-ID: [{}]. Get consent initiation authorisations failed: authorisation not found at CMS by consent id", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), consentId});
            return ResponseObject.builder().fail(ErrorType.AIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404)).build();
        });
    }

    public ResponseObject<ScaStatus> getConsentAuthorisationScaStatus(String consentId, String authorisationId) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.GET_CONSENT_SCA_STATUS_REQUEST_RECEIVED);
        Optional<AccountConsent> accountConsent = this.aisConsentService.getAccountConsentById(consentId);
        if (!accountConsent.isPresent()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Consent-ID: [{}]. Get consent authorisation SCA status failed: consent not found by id", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), consentId});
            return ResponseObject.builder().fail(ErrorType.AIS_403, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_403)).build();
        }
        ValidationResult validationResult = this.getConsentAuthorisationScaStatusValidator.validate(new CommonConsentObject(accountConsent.get()));
        if (validationResult.isNotValid()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Consent-ID: [{}], Authorisation-ID [{}]. Get consent authorisation SCA status - validation failed: {}", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), consentId, authorisationId, validationResult.getMessageError()});
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        Optional<ScaStatus> scaStatus = ((AisAuthorizationService)this.aisScaAuthorisationServiceResolver.getServiceInitiation(authorisationId)).getAuthorisationScaStatus(consentId, authorisationId);
        if (!scaStatus.isPresent()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Consent-ID: [{}]. Get consent authorisation SCA status failed: consent not found at CMS by id", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), consentId});
            return ResponseObject.builder().fail(ErrorType.AIS_403, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_403)).build();
        }
        return ResponseObject.builder().body(scaStatus.get()).build();
    }

    private SpiResponse<SpiAisConsentStatusResponse> getConsentStatusFromSpi(AccountConsent accountConsent, String consentId) {
        SpiAccountConsent spiAccountConsent = this.aisConsentMapper.mapToSpiAccountConsent(accountConsent);
        SpiAspspConsentDataProvider aspspDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId);
        return this.aisConsentSpi.getConsentStatus(this.spiContextDataProvider.provide(), spiAccountConsent, aspspDataProvider);
    }

    private Xs2aAccountAccess getAccessForGlobalOrAllAvailableAccountsConsent(CreateConsentReq request) {
        return new Xs2aAccountAccess(new ArrayList<AccountReference>(), new ArrayList<AccountReference>(), new ArrayList<AccountReference>(), request.getAccess().getAvailableAccounts(), request.getAccess().getAllPsd2(), request.getAccess().getAvailableAccountsWithBalance());
    }

    private void proceedImplicitCaseForCreateConsent(CreateConsentResponse response, PsuIdData psuData, String consentId) {
        ((AisAuthorizationService)this.aisScaAuthorisationServiceResolver.getService()).createConsentAuthorization(psuData, consentId).ifPresent(a -> response.setAuthorizationId(a.getAuthorisationId()));
    }

    private SpiContextData getSpiContextData() {
        PsuIdData psuIdData = this.requestProviderService.getPsuIdData();
        log.info("X-Request-ID: [{}]. Corresponding PSU-ID {} was provided from request.", (Object)this.requestProviderService.getRequestId(), (Object)psuIdData);
        return this.spiContextDataProvider.provideWithPsuIdData(psuIdData);
    }

    private Optional<Xs2aAuthorisationSubResources> getAuthorisationSubResources(String consentId) {
        return this.aisConsentService.getAuthorisationSubResources(consentId).map(Xs2aAuthorisationSubResources::new);
    }

    @ConstructorProperties(value={"aisConsentMapper", "spiToXs2aAccountAccessMapper", "aisConsentService", "aisScaAuthorisationServiceResolver", "tppService", "endpointAccessCheckerService", "spiContextDataProvider", "authorisationMethodDecider", "aisConsentSpi", "xs2aEventService", "accountReferenceUpdater", "spiErrorMapper", "createConsentRequestValidator", "getAccountConsentsStatusByIdValidator", "getAccountConsentByIdValidator", "deleteAccountConsentsByIdValidator", "createConsentAuthorisationValidator", "updateConsentPsuDataValidator", "getConsentAuthorisationsValidator", "getConsentAuthorisationScaStatusValidator", "aisScaAuthorisationService", "requestProviderService", "aspspConsentDataProviderFactory"})
    public ConsentService(Xs2aAisConsentMapper aisConsentMapper, SpiToXs2aAccountAccessMapper spiToXs2aAccountAccessMapper, Xs2aAisConsentService aisConsentService, AisScaAuthorisationServiceResolver aisScaAuthorisationServiceResolver, TppService tppService, AisEndpointAccessCheckerService endpointAccessCheckerService, SpiContextDataProvider spiContextDataProvider, AuthorisationMethodDecider authorisationMethodDecider, AisConsentSpi aisConsentSpi, Xs2aEventService xs2aEventService, AccountReferenceInConsentUpdater accountReferenceUpdater, SpiErrorMapper spiErrorMapper, CreateConsentRequestValidator createConsentRequestValidator, GetAccountConsentsStatusByIdValidator getAccountConsentsStatusByIdValidator, GetAccountConsentByIdValidator getAccountConsentByIdValidator, DeleteAccountConsentsByIdValidator deleteAccountConsentsByIdValidator, CreateConsentAuthorisationValidator createConsentAuthorisationValidator, UpdateConsentPsuDataValidator updateConsentPsuDataValidator, GetConsentAuthorisationsValidator getConsentAuthorisationsValidator, GetConsentAuthorisationScaStatusValidator getConsentAuthorisationScaStatusValidator, AisScaAuthorisationService aisScaAuthorisationService, RequestProviderService requestProviderService, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory) {
        this.aisConsentMapper = aisConsentMapper;
        this.spiToXs2aAccountAccessMapper = spiToXs2aAccountAccessMapper;
        this.aisConsentService = aisConsentService;
        this.aisScaAuthorisationServiceResolver = aisScaAuthorisationServiceResolver;
        this.tppService = tppService;
        this.endpointAccessCheckerService = endpointAccessCheckerService;
        this.spiContextDataProvider = spiContextDataProvider;
        this.authorisationMethodDecider = authorisationMethodDecider;
        this.aisConsentSpi = aisConsentSpi;
        this.xs2aEventService = xs2aEventService;
        this.accountReferenceUpdater = accountReferenceUpdater;
        this.spiErrorMapper = spiErrorMapper;
        this.createConsentRequestValidator = createConsentRequestValidator;
        this.getAccountConsentsStatusByIdValidator = getAccountConsentsStatusByIdValidator;
        this.getAccountConsentByIdValidator = getAccountConsentByIdValidator;
        this.deleteAccountConsentsByIdValidator = deleteAccountConsentsByIdValidator;
        this.createConsentAuthorisationValidator = createConsentAuthorisationValidator;
        this.updateConsentPsuDataValidator = updateConsentPsuDataValidator;
        this.getConsentAuthorisationsValidator = getConsentAuthorisationsValidator;
        this.getConsentAuthorisationScaStatusValidator = getConsentAuthorisationScaStatusValidator;
        this.aisScaAuthorisationService = aisScaAuthorisationService;
        this.requestProviderService = requestProviderService;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
    }
}

