/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.component.logger;

import de.adorsys.psd2.xs2a.component.logger.TppLogType;
import de.adorsys.psd2.xs2a.component.logger.TppLogger;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class TppRequestLogBuilder
extends TppLogger.TppLogBuilder<TppRequestLogBuilder> {
    private static final String TPP_ID = "TPP ID";
    private static final String TPP_IP_ADDRESS = "TPP IP Address";
    private static final String TPP_ROLES = "TPP Roles";
    private static final String TPP_ROLES_SEPARATOR = ",";
    private static final String REQUEST_URI = "URI";
    private HttpServletRequest request;

    TppRequestLogBuilder(HttpServletRequest httpServletRequest) {
        super(TppLogType.REQUEST);
        this.request = httpServletRequest;
    }

    public TppRequestLogBuilder withTpp(TppInfo tppInfo) {
        this.putLogParameter(TPP_ID, tppInfo.getAuthorisationNumber());
        this.putLogParameter(TPP_IP_ADDRESS, this.request.getRemoteAddr());
        this.putLogParameter(TPP_ROLES, StringUtils.join((Iterable)tppInfo.getTppRoles(), (String)TPP_ROLES_SEPARATOR));
        return this;
    }

    public TppRequestLogBuilder withRequestUri() {
        this.putLogParameter(REQUEST_URI, this.request.getRequestURI());
        return this;
    }

    @Override
    protected String getXRequestIdValue() {
        return this.request.getHeader("x-request-id");
    }

    @Override
    protected TppRequestLogBuilder getThis() {
        return this;
    }
}

