package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.psd2.xs2a.web.mapper.RemittanceMapper;
import javax.annotation.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2019-08-30T09:29:50+0000",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 1.8.0_222 (Private Build)"
)
@Component
public class SpiToXs2aPeriodicPaymentMapperImpl implements SpiToXs2aPeriodicPaymentMapper {

    @Autowired
    private SpiToXs2aAccountReferenceMapper spiToXs2aAccountReferenceMapper;
    @Autowired
    private SpiToXs2aAmountMapper spiToXs2aAmountMapper;
    @Autowired
    private SpiToXs2aAddressMapper spiToXs2aAddressMapper;
    @Autowired
    private RemittanceMapper remittanceMapper;

    @Override
    public PeriodicPayment mapToXs2aPeriodicPayment(SpiPeriodicPayment payment) {
        if ( payment == null ) {
            return null;
        }

        PeriodicPayment periodicPayment = new PeriodicPayment();

        periodicPayment.setTransactionStatus( payment.getPaymentStatus() );
        periodicPayment.setPaymentId( payment.getPaymentId() );
        periodicPayment.setEndToEndIdentification( payment.getEndToEndIdentification() );
        periodicPayment.setDebtorAccount( spiToXs2aAccountReferenceMapper.mapToXs2aAccountReference( payment.getDebtorAccount() ) );
        periodicPayment.setUltimateDebtor( payment.getUltimateDebtor() );
        periodicPayment.setInstructedAmount( spiToXs2aAmountMapper.mapToXs2aAmount( payment.getInstructedAmount() ) );
        periodicPayment.setCreditorAccount( spiToXs2aAccountReferenceMapper.mapToXs2aAccountReference( payment.getCreditorAccount() ) );
        periodicPayment.setCreditorAgent( payment.getCreditorAgent() );
        periodicPayment.setCreditorName( payment.getCreditorName() );
        periodicPayment.setCreditorAddress( spiToXs2aAddressMapper.mapToAddress( payment.getCreditorAddress() ) );
        periodicPayment.setUltimateCreditor( payment.getUltimateCreditor() );
        periodicPayment.setPurposeCode( payment.getPurposeCode() );
        periodicPayment.setRemittanceInformationUnstructured( payment.getRemittanceInformationUnstructured() );
        periodicPayment.setRemittanceInformationStructured( remittanceMapper.mapToRemittance( payment.getRemittanceInformationStructured() ) );
        periodicPayment.setRequestedExecutionDate( payment.getRequestedExecutionDate() );
        periodicPayment.setRequestedExecutionTime( payment.getRequestedExecutionTime() );
        periodicPayment.setStatusChangeTimestamp( payment.getStatusChangeTimestamp() );
        periodicPayment.setStartDate( payment.getStartDate() );
        periodicPayment.setExecutionRule( payment.getExecutionRule() );
        periodicPayment.setEndDate( payment.getEndDate() );
        periodicPayment.setFrequency( payment.getFrequency() );
        periodicPayment.setDayOfExecution( payment.getDayOfExecution() );

        return periodicPayment;
    }
}
