package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.domain.BalanceType;
import de.adorsys.psd2.xs2a.domain.Xs2aBalance;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountBalance;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiBalanceType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2019-08-30T09:29:50+0000",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 1.8.0_222 (Private Build)"
)
@Component
public class SpiToXs2aBalanceMapperImpl implements SpiToXs2aBalanceMapper {

    @Autowired
    private SpiToXs2aAmountMapper spiToXs2aAmountMapper;

    @Override
    public Xs2aBalance mapToXs2aBalance(SpiAccountBalance spiAccountBalance) {
        if ( spiAccountBalance == null ) {
            return null;
        }

        Xs2aBalance xs2aBalance = new Xs2aBalance();

        xs2aBalance.setBalanceAmount( spiToXs2aAmountMapper.mapToXs2aAmount( spiAccountBalance.getSpiBalanceAmount() ) );
        xs2aBalance.setBalanceType( spiBalanceTypeToBalanceType( spiAccountBalance.getSpiBalanceType() ) );
        xs2aBalance.setLastChangeDateTime( spiAccountBalance.getLastChangeDateTime() );
        xs2aBalance.setReferenceDate( spiAccountBalance.getReferenceDate() );
        xs2aBalance.setLastCommittedTransaction( spiAccountBalance.getLastCommittedTransaction() );
        xs2aBalance.setCreditLimitIncluded( spiAccountBalance.getCreditLimitIncluded() );

        return xs2aBalance;
    }

    @Override
    public List<Xs2aBalance> mapToXs2aBalanceList(List<SpiAccountBalance> spiBalances) {
        if ( spiBalances == null ) {
            return new ArrayList<Xs2aBalance>();
        }

        List<Xs2aBalance> list = new ArrayList<Xs2aBalance>( spiBalances.size() );
        for ( SpiAccountBalance spiAccountBalance : spiBalances ) {
            list.add( mapToXs2aBalance( spiAccountBalance ) );
        }

        return list;
    }

    protected BalanceType spiBalanceTypeToBalanceType(SpiBalanceType spiBalanceType) {
        if ( spiBalanceType == null ) {
            return null;
        }

        BalanceType balanceType;

        switch ( spiBalanceType ) {
            case CLOSING_BOOKED: balanceType = BalanceType.CLOSING_BOOKED;
            break;
            case EXPECTED: balanceType = BalanceType.EXPECTED;
            break;
            case AUTHORISED: balanceType = BalanceType.AUTHORISED;
            break;
            case OPENING_BOOKED: balanceType = BalanceType.OPENING_BOOKED;
            break;
            case INTERIM_AVAILABLE: balanceType = BalanceType.INTERIM_AVAILABLE;
            break;
            case FORWARD_AVAILABLE: balanceType = BalanceType.FORWARD_AVAILABLE;
            break;
            case NONINVOICED: balanceType = BalanceType.NONINVOICED;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + spiBalanceType );
        }

        return balanceType;
    }
}
