/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.methods.service;

import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.service.discovery.ServiceTypeDiscoveryService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceTypeToErrorTypeMapper;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import java.beans.ConstructorProperties;
import java.util.Objects;
import org.springframework.stereotype.Service;

@Service
public class PsuIpAddressValidationService {
    private static final String IP_PATTERN_v4 = "^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$";
    private static final String IP_PATTERN_v6 = "^(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))$";
    private static final String ERROR_TEXT_NULL_IP_ADDRESS = "'PSU-IP-Address' may not be null";
    private static final String ERROR_TEXT_WRONG_IP_ADDRESS = "'PSU-IP-Address' has to be correct v.4 or v.6 IP address";
    private final ServiceTypeDiscoveryService serviceTypeDiscoveryService;
    private final ServiceTypeToErrorTypeMapper errorTypeMapper;

    public ValidationResult validatePsuIdAddress(String psuIpAddress) {
        if (Objects.isNull(psuIpAddress)) {
            return ValidationResult.invalid(this.buildErrorType(), TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR, ERROR_TEXT_NULL_IP_ADDRESS));
        }
        if (this.isNonValid(psuIpAddress)) {
            return ValidationResult.invalid(this.buildErrorType(), TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR, ERROR_TEXT_WRONG_IP_ADDRESS));
        }
        return ValidationResult.valid();
    }

    private boolean isNonValid(String psuIpAddress) {
        return !psuIpAddress.matches(IP_PATTERN_v4) && !psuIpAddress.matches(IP_PATTERN_v6);
    }

    private ErrorType buildErrorType() {
        return this.errorTypeMapper.mapToErrorType(this.serviceTypeDiscoveryService.getServiceType(), MessageErrorCode.FORMAT_ERROR.getCode());
    }

    @ConstructorProperties(value={"serviceTypeDiscoveryService", "errorTypeMapper"})
    public PsuIpAddressValidationService(ServiceTypeDiscoveryService serviceTypeDiscoveryService, ServiceTypeToErrorTypeMapper errorTypeMapper) {
        this.serviceTypeDiscoveryService = serviceTypeDiscoveryService;
        this.errorTypeMapper = errorTypeMapper;
    }
}

