/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.methods.factory;

import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.methods.MethodHeadersValidator;
import de.adorsys.psd2.xs2a.web.validator.methods.service.PsuIpAddressValidationService;
import de.adorsys.psd2.xs2a.web.validator.methods.service.TppRedirectUriValidationService;
import java.beans.ConstructorProperties;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Service;

@Service(value="_initiatePayment")
public class InitiatePaymentValidator
implements MethodHeadersValidator {
    private final PsuIpAddressValidationService psuIpAddressValidationService;
    private final ErrorBuildingService errorBuildingService;
    private final TppRedirectUriValidationService tppRedirectUriValidationService;

    @Override
    public boolean validate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String psuIpAddress = request.getHeader("PSU-IP-Address");
        ValidationResult psuIpAddressValidationResult = this.psuIpAddressValidationService.validatePsuIdAddress(psuIpAddress);
        if (psuIpAddressValidationResult.isNotValid()) {
            this.errorBuildingService.buildErrorResponse(response, psuIpAddressValidationResult.getMessageError());
            return false;
        }
        ValidationResult tppRedirectValidationResult = this.validateInitiatePaymentHeaders(request);
        if (tppRedirectValidationResult.isNotValid()) {
            this.errorBuildingService.buildErrorResponse(response, tppRedirectValidationResult.getMessageError());
            return false;
        }
        return true;
    }

    private ValidationResult validateInitiatePaymentHeaders(HttpServletRequest request) {
        String tppRedirectUri;
        boolean tppRedirectPreferred = Boolean.parseBoolean(request.getHeader("TPP-Redirect-Preferred"));
        if (this.tppRedirectUriValidationService.isNotValid(tppRedirectPreferred, tppRedirectUri = request.getHeader("TPP-Redirect-URI"))) {
            return ValidationResult.invalid(ErrorType.PIS_400, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR, "TPP-Redirect-URI is not correct or empty"));
        }
        return ValidationResult.valid();
    }

    @ConstructorProperties(value={"psuIpAddressValidationService", "errorBuildingService", "tppRedirectUriValidationService"})
    public InitiatePaymentValidator(PsuIpAddressValidationService psuIpAddressValidationService, ErrorBuildingService errorBuildingService, TppRedirectUriValidationService tppRedirectUriValidationService) {
        this.psuIpAddressValidationService = psuIpAddressValidationService;
        this.errorBuildingService = errorBuildingService;
        this.tppRedirectUriValidationService = tppRedirectUriValidationService;
    }
}

