/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.methods.factory;

import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.methods.MethodHeadersValidator;
import de.adorsys.psd2.xs2a.web.validator.methods.service.TppRedirectUriValidationService;
import java.beans.ConstructorProperties;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Service;

@Service(value="_createConsent")
public class CreateConsentValidator
implements MethodHeadersValidator {
    private final ErrorBuildingService errorBuildingService;
    private final TppRedirectUriValidationService tppRedirectUriValidationService;

    @Override
    public boolean validate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ValidationResult creteConsentValidationResult = this.validateCreateConsent(request);
        if (creteConsentValidationResult.isNotValid()) {
            this.errorBuildingService.buildErrorResponse(response, creteConsentValidationResult.getMessageError());
            return false;
        }
        return true;
    }

    private ValidationResult validateCreateConsent(HttpServletRequest request) {
        String tppRedirectUri;
        boolean tppRedirectPreferred = Boolean.parseBoolean(request.getHeader("TPP-Redirect-Preferred"));
        if (this.tppRedirectUriValidationService.isNotValid(tppRedirectPreferred, tppRedirectUri = request.getHeader("TPP-Redirect-URI"))) {
            return ValidationResult.invalid(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR, "TPP-Redirect-URI is not correct or empty"));
        }
        return ValidationResult.valid();
    }

    @ConstructorProperties(value={"errorBuildingService", "tppRedirectUriValidationService"})
    public CreateConsentValidator(ErrorBuildingService errorBuildingService, TppRedirectUriValidationService tppRedirectUriValidationService) {
        this.errorBuildingService = errorBuildingService;
        this.tppRedirectUriValidationService = tppRedirectUriValidationService;
    }
}

