/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.common;

import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.web.validator.AbstractHeadersValidator;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.HeadersValidator;
import de.adorsys.psd2.xs2a.web.validator.common.service.XRequestIdValidationService;
import de.adorsys.psd2.xs2a.web.validator.methods.SpecificMethodsHeadersValidator;
import java.beans.ConstructorProperties;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;

@Component
public class CommonHeadersValidator
extends AbstractHeadersValidator {
    private final XRequestIdValidationService xRequestIdValidationService;
    private final SpecificMethodsHeadersValidator specificMethodsHeadersValidator;
    private final ErrorBuildingService errorBuildingService;

    @Override
    protected boolean validateThis(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        String xRequestId = request.getHeader("X-Request-ID");
        ValidationResult xRequestIdValidationResult = this.xRequestIdValidationService.validateXRequestId(xRequestId);
        if (xRequestIdValidationResult.isNotValid()) {
            this.errorBuildingService.buildErrorResponse(response, xRequestIdValidationResult.getMessageError());
            return false;
        }
        return true;
    }

    @Override
    protected HeadersValidator getNextValidator() {
        return this.specificMethodsHeadersValidator;
    }

    @ConstructorProperties(value={"xRequestIdValidationService", "specificMethodsHeadersValidator", "errorBuildingService"})
    public CommonHeadersValidator(XRequestIdValidationService xRequestIdValidationService, SpecificMethodsHeadersValidator specificMethodsHeadersValidator, ErrorBuildingService errorBuildingService) {
        this.xRequestIdValidationService = xRequestIdValidationService;
        this.specificMethodsHeadersValidator = specificMethodsHeadersValidator;
        this.errorBuildingService = errorBuildingService;
    }
}

