/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.mapper;

import de.adorsys.psd2.api.ConsentApi;
import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.model.ScaStatusResponse;
import de.adorsys.psd2.model.StartScaprocessResponse;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentAuthorizationResponse;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.web.RedirectLinkBuilder;
import de.adorsys.psd2.xs2a.web.mapper.CoreObjectsMapper;
import de.adorsys.psd2.xs2a.web.mapper.HrefLinkMapper;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class AuthorisationMapper {
    private static final Logger log = LoggerFactory.getLogger(AuthorisationMapper.class);
    private final CoreObjectsMapper coreObjectsMapper;
    private final ScaApproachResolver scaApproachResolver;
    private final RedirectLinkBuilder redirectLinkBuilder;
    private final AspspProfileService aspspProfileService;
    private final HrefLinkMapper hrefLinkMapper;

    public StartScaprocessResponse mapToStartScaProcessResponse(CreateConsentAuthorizationResponse createConsentAuthorizationResponse) {
        return Optional.ofNullable(createConsentAuthorizationResponse).map(csar -> {
            boolean redirectApproachUsed = this.scaApproachResolver.resolveScaApproach() == ScaApproach.REDIRECT;
            String link = redirectApproachUsed ? this.redirectLinkBuilder.buildConsentScaRedirectLink(csar.getConsentId(), csar.getAuthorizationId()) : this.createUpdateConsentsPsuDataLink((CreateConsentAuthorizationResponse)csar);
            return new StartScaprocessResponse().scaStatus(this.coreObjectsMapper.mapToModelScaStatus(createConsentAuthorizationResponse.getScaStatus()))._links(this.hrefLinkMapper.mapToLinksMap(csar.getResponseLinkType().getValue(), link));
        }).orElse(null);
    }

    private String createUpdateConsentsPsuDataLink(CreateConsentAuthorizationResponse csar) {
        URI uri = ControllerLinkBuilder.linkTo((Object)((ConsentApi)ControllerLinkBuilder.methodOn(ConsentApi.class, (Object[])new Object[0]))._updateConsentsPsuData(null, csar.getConsentId(), csar.getAuthorizationId(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null)).toUri();
        UriComponentsBuilder uriComponentsBuilder = this.aspspProfileService.getAspspSettings().isForceXs2aBaseUrl() ? UriComponentsBuilder.fromHttpUrl((String)this.aspspProfileService.getAspspSettings().getXs2aBaseUrl()).path(uri.getPath()) : UriComponentsBuilder.fromUri((URI)uri);
        return uriComponentsBuilder.toUriString();
    }

    @NotNull
    public ScaStatusResponse mapToScaStatusResponse(@NotNull ScaStatus scaStatus) {
        return new ScaStatusResponse().scaStatus(this.coreObjectsMapper.mapToModelScaStatus(scaStatus));
    }

    @ConstructorProperties(value={"coreObjectsMapper", "scaApproachResolver", "redirectLinkBuilder", "aspspProfileService", "hrefLinkMapper"})
    public AuthorisationMapper(CoreObjectsMapper coreObjectsMapper, ScaApproachResolver scaApproachResolver, RedirectLinkBuilder redirectLinkBuilder, AspspProfileService aspspProfileService, HrefLinkMapper hrefLinkMapper) {
        this.coreObjectsMapper = coreObjectsMapper;
        this.scaApproachResolver = scaApproachResolver;
        this.redirectLinkBuilder = redirectLinkBuilder;
        this.aspspProfileService = aspspProfileService;
        this.hrefLinkMapper = hrefLinkMapper;
    }
}

