/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.interceptor.logging;

import de.adorsys.psd2.xs2a.component.TppLogger;
import de.adorsys.psd2.xs2a.service.TppService;
import java.beans.ConstructorProperties;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class AccountLoggingInterceptor
extends HandlerInterceptorAdapter {
    private final TppService tppService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        Map pathVariables = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
        TppLogger.logRequest().withParam("TPP ID", this.tppService.getTppId()).withParam("TPP IP", request.getRemoteAddr()).withParam("X-Request-ID", request.getHeader("X-Request-ID")).withParam("URI", request.getRequestURI()).withParam("Account ID", pathVariables.getOrDefault("account-id", "Not exist in URI")).withParam("Consent ID", request.getHeader("Consent-ID")).perform();
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        TppLogger.logResponse().withParam("TPP ID", this.tppService.getTppId()).withParam("X-Request-ID", response.getHeader("X-Request-ID")).withParam("Status", String.valueOf(response.getStatus())).perform();
    }

    @ConstructorProperties(value={"tppService"})
    public AccountLoggingInterceptor(TppService tppService) {
        this.tppService = tppService;
    }
}

