/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.advice;

import de.adorsys.psd2.model.ConsentsResponse201;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.web.LinkExtractor;
import de.adorsys.psd2.xs2a.web.advice.CommonHeaderModifierAdvice;
import de.adorsys.psd2.xs2a.web.controller.ConsentController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;

@ControllerAdvice(assignableTypes={ConsentController.class})
public class ConsentHeaderModifierAdvice
extends CommonHeaderModifierAdvice {
    private static final Logger log = LoggerFactory.getLogger(ConsentHeaderModifierAdvice.class);
    private static final String SELF_LINK_NAME = "self";
    private final LinkExtractor linkExtractor;

    public ConsentHeaderModifierAdvice(ScaApproachResolver scaApproachResolver, LinkExtractor linkExtractor) {
        super(scaApproachResolver);
        this.linkExtractor = linkExtractor;
    }

    @Override
    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    @Override
    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        String methodName = returnType.getMethod().getName();
        if ("_createConsent".equals(methodName)) {
            response.getHeaders().add("Aspsp-Sca-Approach", this.scaApproachResolver.resolveScaApproach().name());
            if (!this.hasError(body, ConsentsResponse201.class)) {
                ConsentsResponse201 consentResponse = (ConsentsResponse201)body;
                String selfLink = this.linkExtractor.extract(consentResponse.getLinks(), SELF_LINK_NAME).orElse(null);
                response.getHeaders().add("Location", selfLink);
            }
        } else if ("_startConsentAuthorisation".equals(methodName) || "_updateConsentsPsuData".equals(methodName)) {
            response.getHeaders().add("Aspsp-Sca-Approach", this.scaApproachResolver.resolveScaApproach().name());
        }
        return body;
    }
}

