/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.pis.payment;

import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.BusinessValidator;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CreatePaymentValidator
implements BusinessValidator<PaymentInitiationParameters> {
    private static final Logger log = LoggerFactory.getLogger(CreatePaymentValidator.class);
    private final AspspProfileServiceWrapper aspspProfileServiceWrapper;
    private final RequestProviderService requestProviderService;

    @Override
    @NotNull
    public ValidationResult validate(@NotNull PaymentInitiationParameters paymentInitiationParameters) {
        if (this.aspspProfileServiceWrapper.isPsuInInitialRequestMandated() && paymentInitiationParameters.getPsuData().isEmpty()) {
            log.info("X-Request-ID: [{}]. Payment initiation has failed: no PSU Data was provided in the request", (Object)this.requestProviderService.getRequestId());
            return ValidationResult.invalid(ErrorType.PIS_400, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR, "Please provide the PSU identification data"));
        }
        return ValidationResult.valid();
    }

    @ConstructorProperties(value={"aspspProfileServiceWrapper", "requestProviderService"})
    public CreatePaymentValidator(AspspProfileServiceWrapper aspspProfileServiceWrapper, RequestProviderService requestProviderService) {
        this.aspspProfileServiceWrapper = aspspProfileServiceWrapper;
        this.requestProviderService = requestProviderService;
    }
}

