/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.consent;

import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccess;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.BusinessValidator;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class CreateConsentRequestValidator
implements BusinessValidator<CreateConsentReq> {
    private final AspspProfileServiceWrapper aspspProfileService;
    private final ScaApproachResolver scaApproachResolver;

    @Override
    @NotNull
    public ValidationResult validate(@NotNull CreateConsentReq request) {
        if (this.isNotSupportedGlobalConsentForAllPsd2(request)) {
            return ValidationResult.invalid(ErrorType.AIS_400, MessageErrorCode.PARAMETER_NOT_SUPPORTED);
        }
        if (this.isNotSupportedBankOfferedConsent(request)) {
            return ValidationResult.invalid(ErrorType.AIS_405, MessageErrorCode.SERVICE_INVALID_405);
        }
        if (this.isNotValidExpirationDate(request.getValidUntil())) {
            return ValidationResult.invalid(ErrorType.AIS_400, MessageErrorCode.PERIOD_INVALID);
        }
        if (this.isNotValidFrequencyPerDay(request.isRecurringIndicator(), request.getFrequencyPerDay())) {
            return ValidationResult.invalid(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR, "Value of frequencyPerDay is not correct"));
        }
        if (this.isNotSupportedAvailableAccounts(request)) {
            return ValidationResult.invalid(ErrorType.AIS_405, MessageErrorCode.SERVICE_INVALID_405);
        }
        if (this.areFlagsAndAccountsInvalid(request)) {
            return ValidationResult.invalid(ErrorType.AIS_400, MessageErrorCode.FORMAT_ERROR);
        }
        if (this.isNotSupportedCombinedServiceIndicator(request)) {
            return ValidationResult.invalid(ErrorType.AIS_400, MessageErrorCode.SESSIONS_NOT_SUPPORTED);
        }
        return ValidationResult.valid();
    }

    private boolean areFlagsAndAccountsInvalid(CreateConsentReq request) {
        Xs2aAccountAccess access = request.getAccess();
        if (access.isNotEmpty()) {
            return !CollectionUtils.isEmpty(request.getAccountReferences()) && !this.areFlagsEmpty(access);
        }
        return false;
    }

    private boolean areFlagsEmpty(Xs2aAccountAccess access) {
        return Objects.isNull(access.getAvailableAccounts()) && Objects.isNull(access.getAllPsd2());
    }

    private boolean isNotSupportedGlobalConsentForAllPsd2(CreateConsentReq request) {
        return this.isConsentGlobal(request) && this.aspspProfileService.getAllPsd2Support() == false;
    }

    private boolean isNotSupportedBankOfferedConsent(CreateConsentReq request) {
        if (this.isNotEmptyAccess(request.getAccess()).booleanValue()) {
            return false;
        }
        if (this.scaApproachResolver.resolveScaApproach() == ScaApproach.EMBEDDED) {
            return true;
        }
        return !this.aspspProfileService.isBankOfferedConsentSupported();
    }

    private boolean isNotValidExpirationDate(LocalDate validUntil) {
        return validUntil.isBefore(LocalDate.now());
    }

    private boolean isConsentGlobal(CreateConsentReq request) {
        return this.isNotEmptyAccess(request.getAccess()) != false && request.getAccess().getAllPsd2() == AccountAccessType.ALL_ACCOUNTS;
    }

    private Boolean isNotEmptyAccess(Xs2aAccountAccess access) {
        return Optional.ofNullable(access).map(Xs2aAccountAccess::isNotEmpty).orElse(false);
    }

    private boolean isNotValidFrequencyPerDay(boolean recurringIndicator, int frequencyPerDay) {
        return recurringIndicator ? frequencyPerDay <= 0 : frequencyPerDay != 1;
    }

    private boolean isNotSupportedAvailableAccounts(CreateConsentReq request) {
        if (Objects.isNull(request.getAccess().getAvailableAccounts())) {
            return false;
        }
        return !this.aspspProfileService.isAvailableAccountsConsentSupported();
    }

    private boolean isNotSupportedCombinedServiceIndicator(CreateConsentReq request) {
        return request.isCombinedServiceIndicator() && !this.aspspProfileService.isCombinedServiceIndicator();
    }

    @ConstructorProperties(value={"aspspProfileService", "scaApproachResolver"})
    public CreateConsentRequestValidator(AspspProfileServiceWrapper aspspProfileService, ScaApproachResolver scaApproachResolver) {
        this.aspspProfileService = aspspProfileService;
        this.scaApproachResolver = scaApproachResolver;
    }
}

