/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator;

import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.service.AccountReferenceValidationService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class PaymentValidationService {
    private final AccountReferenceValidationService referenceValidationService;

    public ResponseObject validateSinglePayment(SinglePayment singePayment) {
        ResponseObject accountReferenceValidationResponse = this.referenceValidationService.validateAccountReferences(singePayment.getAccountReferences());
        if (accountReferenceValidationResponse.hasError()) {
            return this.buildErrorResponse(MessageErrorCode.FORMAT_ERROR);
        }
        return this.isDateInThePast(singePayment.getRequestedExecutionDate()) ? this.buildErrorResponse(MessageErrorCode.PERIOD_INVALID) : ResponseObject.builder().build();
    }

    public ResponseObject validatePeriodicPayment(PeriodicPayment periodicPayment) {
        ResponseObject accountReferenceValidationResponse = this.referenceValidationService.validateAccountReferences(periodicPayment.getAccountReferences());
        if (accountReferenceValidationResponse.hasError()) {
            return this.buildErrorResponse(MessageErrorCode.FORMAT_ERROR);
        }
        return this.areDatesInvalidInPeriodicPayment(periodicPayment) ? this.buildErrorResponse(MessageErrorCode.PERIOD_INVALID) : ResponseObject.builder().build();
    }

    public ResponseObject validateBulkPayment(BulkPayment bulkPayment) {
        ResponseObject accountReferenceValidationResponse = this.referenceValidationService.validateAccountReferences(Collections.singleton(bulkPayment.getDebtorAccount()));
        if (accountReferenceValidationResponse.hasError()) {
            return this.buildErrorResponse(MessageErrorCode.FORMAT_ERROR);
        }
        return this.isDateInThePast(bulkPayment.getRequestedExecutionDate()) ? this.buildErrorResponse(MessageErrorCode.PERIOD_INVALID) : ResponseObject.builder().build();
    }

    private boolean areDatesInvalidInPeriodicPayment(PeriodicPayment periodicPayment) {
        LocalDate paymentStartDate = periodicPayment.getStartDate();
        LocalDate paymentEndDate = periodicPayment.getEndDate();
        return this.isDateInThePast(paymentStartDate) || Optional.ofNullable(paymentEndDate).map(dt -> dt.isBefore(paymentStartDate)).orElse(false) != false;
    }

    private boolean isDateInThePast(LocalDate dateToCheck) {
        return Optional.ofNullable(dateToCheck).map(date -> date.isBefore(LocalDate.now())).orElse(false);
    }

    private ResponseObject buildErrorResponse(MessageErrorCode errorCode) {
        return ResponseObject.builder().fail(ErrorType.PIS_400, TppMessageInformation.of(errorCode)).build();
    }

    @ConstructorProperties(value={"referenceValidationService"})
    public PaymentValidationService(AccountReferenceValidationService referenceValidationService) {
        this.referenceValidationService = referenceValidationService;
    }
}

