/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment.sca;

import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.BulkPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.domain.pis.CommonPayment;
import de.adorsys.psd2.xs2a.domain.pis.CommonPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.domain.pis.SinglePaymentInitiationResponse;
import de.adorsys.psd2.xs2a.service.authorization.ScaApproachServiceTypeProvider;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiBulkPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPaymentInfo;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPeriodicPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiSinglePaymentMapper;
import de.adorsys.psd2.xs2a.service.spi.InitialSpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.BulkPaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.CommonPaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.PeriodicPaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.SinglePaymentSpi;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Service;

@Service
public abstract class ScaPaymentService
implements ScaApproachServiceTypeProvider {
    private final SinglePaymentSpi singlePaymentSpi;
    private final PeriodicPaymentSpi periodicPaymentSpi;
    private final BulkPaymentSpi bulkPaymentSpi;
    private final CommonPaymentSpi commonPaymentSpi;
    private final Xs2aToSpiSinglePaymentMapper xs2AToSpiSinglePaymentMapper;
    private final Xs2aToSpiPeriodicPaymentMapper xs2aToSpiPeriodicPaymentMapper;
    private final Xs2aToSpiBulkPaymentMapper xs2aToSpiBulkPaymentMapper;
    private final Xs2aToSpiPaymentInfo xs2aToSpiPaymentInfo;
    private final SpiToXs2aPaymentMapper spiToXs2aPaymentMapper;
    private final SpiContextDataProvider spiContextDataProvider;
    private final SpiErrorMapper spiErrorMapper;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;

    public SinglePaymentInitiationResponse createSinglePayment(SinglePayment payment, TppInfo tppInfo, String paymentProduct, PsuIdData psuIdData) {
        SpiContextData spiContextData = this.spiContextDataProvider.provideWithPsuIdData(psuIdData);
        InitialSpiAspspConsentDataProvider aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getInitialAspspConsentDataProvider();
        SpiResponse spiResponse = this.singlePaymentSpi.initiatePayment(spiContextData, this.xs2AToSpiSinglePaymentMapper.mapToSpiSinglePayment(payment, paymentProduct), (SpiAspspConsentDataProvider)aspspConsentDataProvider);
        if (spiResponse.getAspspConsentData() != null) {
            aspspConsentDataProvider.updateAspspConsentData(spiResponse.getAspspConsentData().getAspspConsentData());
        }
        if (spiResponse.hasError()) {
            return new SinglePaymentInitiationResponse(this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS));
        }
        return this.spiToXs2aPaymentMapper.mapToPaymentInitiateResponse((SpiPaymentInitiationResponse)spiResponse.getPayload(), SinglePaymentInitiationResponse::new, aspspConsentDataProvider);
    }

    public PeriodicPaymentInitiationResponse createPeriodicPayment(PeriodicPayment payment, TppInfo tppInfo, String paymentProduct, PsuIdData psuIdData) {
        SpiContextData spiContextData = this.spiContextDataProvider.provideWithPsuIdData(psuIdData);
        InitialSpiAspspConsentDataProvider aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getInitialAspspConsentDataProvider();
        SpiResponse spiResponse = this.periodicPaymentSpi.initiatePayment(spiContextData, this.xs2aToSpiPeriodicPaymentMapper.mapToSpiPeriodicPayment(payment, paymentProduct), (SpiAspspConsentDataProvider)aspspConsentDataProvider);
        if (spiResponse.getAspspConsentData() != null) {
            aspspConsentDataProvider.updateAspspConsentData(spiResponse.getAspspConsentData().getAspspConsentData());
        }
        if (spiResponse.hasError()) {
            return new PeriodicPaymentInitiationResponse(this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS));
        }
        return this.spiToXs2aPaymentMapper.mapToPaymentInitiateResponse((SpiPaymentInitiationResponse)spiResponse.getPayload(), PeriodicPaymentInitiationResponse::new, aspspConsentDataProvider);
    }

    public BulkPaymentInitiationResponse createBulkPayment(BulkPayment bulkPayment, TppInfo tppInfo, String paymentProduct, PsuIdData psuIdData) {
        SpiContextData spiContextData = this.spiContextDataProvider.provideWithPsuIdData(psuIdData);
        InitialSpiAspspConsentDataProvider aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getInitialAspspConsentDataProvider();
        SpiResponse spiResponse = this.bulkPaymentSpi.initiatePayment(spiContextData, this.xs2aToSpiBulkPaymentMapper.mapToSpiBulkPayment(bulkPayment, paymentProduct), (SpiAspspConsentDataProvider)aspspConsentDataProvider);
        if (spiResponse.getAspspConsentData() != null) {
            aspspConsentDataProvider.updateAspspConsentData(spiResponse.getAspspConsentData().getAspspConsentData());
        }
        if (spiResponse.hasError()) {
            return new BulkPaymentInitiationResponse(this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS));
        }
        return this.spiToXs2aPaymentMapper.mapToPaymentInitiateResponse((SpiPaymentInitiationResponse)spiResponse.getPayload(), BulkPaymentInitiationResponse::new, aspspConsentDataProvider);
    }

    public CommonPaymentInitiationResponse createCommonPayment(CommonPayment payment, TppInfo tppInfo, String paymentProduct, PsuIdData psuIdData) {
        SpiContextData spiContextData = this.spiContextDataProvider.provide(psuIdData, tppInfo);
        InitialSpiAspspConsentDataProvider aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getInitialAspspConsentDataProvider();
        SpiResponse spiResponse = this.commonPaymentSpi.initiatePayment(spiContextData, this.xs2aToSpiPaymentInfo.mapToSpiPaymentRequest(payment, paymentProduct), (SpiAspspConsentDataProvider)aspspConsentDataProvider);
        if (spiResponse.getAspspConsentData() != null) {
            aspspConsentDataProvider.updateAspspConsentData(spiResponse.getAspspConsentData().getAspspConsentData());
        }
        if (spiResponse.hasError()) {
            return new CommonPaymentInitiationResponse(this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS));
        }
        return this.spiToXs2aPaymentMapper.mapToCommonPaymentInitiateResponse((SpiPaymentInitiationResponse)spiResponse.getPayload(), payment.getPaymentType(), aspspConsentDataProvider);
    }

    @ConstructorProperties(value={"singlePaymentSpi", "periodicPaymentSpi", "bulkPaymentSpi", "commonPaymentSpi", "xs2AToSpiSinglePaymentMapper", "xs2aToSpiPeriodicPaymentMapper", "xs2aToSpiBulkPaymentMapper", "xs2aToSpiPaymentInfo", "spiToXs2aPaymentMapper", "spiContextDataProvider", "spiErrorMapper", "aspspConsentDataProviderFactory"})
    public ScaPaymentService(SinglePaymentSpi singlePaymentSpi, PeriodicPaymentSpi periodicPaymentSpi, BulkPaymentSpi bulkPaymentSpi, CommonPaymentSpi commonPaymentSpi, Xs2aToSpiSinglePaymentMapper xs2AToSpiSinglePaymentMapper, Xs2aToSpiPeriodicPaymentMapper xs2aToSpiPeriodicPaymentMapper, Xs2aToSpiBulkPaymentMapper xs2aToSpiBulkPaymentMapper, Xs2aToSpiPaymentInfo xs2aToSpiPaymentInfo, SpiToXs2aPaymentMapper spiToXs2aPaymentMapper, SpiContextDataProvider spiContextDataProvider, SpiErrorMapper spiErrorMapper, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory) {
        this.singlePaymentSpi = singlePaymentSpi;
        this.periodicPaymentSpi = periodicPaymentSpi;
        this.bulkPaymentSpi = bulkPaymentSpi;
        this.commonPaymentSpi = commonPaymentSpi;
        this.xs2AToSpiSinglePaymentMapper = xs2AToSpiSinglePaymentMapper;
        this.xs2aToSpiPeriodicPaymentMapper = xs2aToSpiPeriodicPaymentMapper;
        this.xs2aToSpiBulkPaymentMapper = xs2aToSpiBulkPaymentMapper;
        this.xs2aToSpiPaymentInfo = xs2aToSpiPaymentInfo;
        this.spiToXs2aPaymentMapper = spiToXs2aPaymentMapper;
        this.spiContextDataProvider = spiContextDataProvider;
        this.spiErrorMapper = spiErrorMapper;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
    }
}

