/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment;

import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.pis.ReadPaymentStatusResponse;
import de.adorsys.psd2.xs2a.service.consent.PisAspspDataService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.payment.ReadPaymentStatusService;
import de.adorsys.psd2.xs2a.service.payment.SpiPaymentFactory;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.PeriodicPaymentSpi;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service(value="status-periodic-payments")
public class ReadPeriodicPaymentStatusService
implements ReadPaymentStatusService {
    private final PisAspspDataService pisAspspDataService;
    private final SpiPaymentFactory spiPaymentFactory;
    private final SpiErrorMapper spiErrorMapper;
    private final PeriodicPaymentSpi periodicPaymentSpi;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;

    @Override
    public ReadPaymentStatusResponse readPaymentStatus(List<PisPayment> pisPayments, String paymentProduct, SpiContextData spiContextData, @NotNull String encryptedPaymentId) {
        Optional<SpiPeriodicPayment> spiPeriodicPaymentOptional = this.spiPaymentFactory.createSpiPeriodicPayment(pisPayments.get(0), paymentProduct);
        if (!spiPeriodicPaymentOptional.isPresent()) {
            return new ReadPaymentStatusResponse(ErrorHolder.builder(MessageErrorCode.RESOURCE_UNKNOWN_404).messages(Collections.singletonList("Payment not found")).build());
        }
        SpiAspspConsentDataProvider aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(encryptedPaymentId);
        SpiResponse spiResponse = this.periodicPaymentSpi.getPaymentStatusById(spiContextData, spiPeriodicPaymentOptional.get(), aspspConsentDataProvider);
        if (spiResponse.getAspspConsentData() != null) {
            aspspConsentDataProvider.updateAspspConsentData(spiResponse.getAspspConsentData().getAspspConsentData());
        }
        if (spiResponse.hasError()) {
            return new ReadPaymentStatusResponse(this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS));
        }
        return new ReadPaymentStatusResponse((TransactionStatus)spiResponse.getPayload());
    }

    @ConstructorProperties(value={"pisAspspDataService", "spiPaymentFactory", "spiErrorMapper", "periodicPaymentSpi", "aspspConsentDataProviderFactory"})
    public ReadPeriodicPaymentStatusService(PisAspspDataService pisAspspDataService, SpiPaymentFactory spiPaymentFactory, SpiErrorMapper spiErrorMapper, PeriodicPaymentSpi periodicPaymentSpi, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory) {
        this.pisAspspDataService = pisAspspDataService;
        this.spiPaymentFactory = spiPaymentFactory;
        this.spiErrorMapper = spiErrorMapper;
        this.periodicPaymentSpi = periodicPaymentSpi;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
    }
}

