/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.psd2.sb;

import de.adorsys.psd2.model.Error405NGSBS;
import de.adorsys.psd2.model.MessageCode405SBS;
import de.adorsys.psd2.model.TppMessage405SBS;
import de.adorsys.psd2.model.TppMessageCategory;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.mapper.psd2.Psd2ErrorMapper;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class SB405ErrorMapper
extends Psd2ErrorMapper<MessageError, Error405NGSBS> {
    @Override
    public Function<MessageError, Error405NGSBS> getMapper() {
        return this::mapToPsd2Error;
    }

    @Override
    public HttpStatus getErrorStatus() {
        return HttpStatus.METHOD_NOT_ALLOWED;
    }

    private Error405NGSBS mapToPsd2Error(MessageError messageError) {
        return new Error405NGSBS().tppMessages(this.mapToTppMessage405SB(messageError.getTppMessages()));
    }

    private List<TppMessage405SBS> mapToTppMessage405SB(Set<TppMessageInformation> tppMessages) {
        return tppMessages.stream().map(m -> new TppMessage405SBS().category(TppMessageCategory.fromValue((String)m.getCategory().name())).code(MessageCode405SBS.fromValue((String)m.getMessageErrorCode().getName())).path(m.getPath()).text(this.getErrorText((TppMessageInformation)m))).collect(Collectors.toList());
    }
}

