/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.psd2.pis;

import de.adorsys.psd2.model.TppMessageCategory;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.exception.model.error500.Error500NGPIS;
import de.adorsys.psd2.xs2a.exception.model.error500.MessageCode500PIS;
import de.adorsys.psd2.xs2a.exception.model.error500.TppMessage500PIS;
import de.adorsys.psd2.xs2a.service.mapper.psd2.Psd2ErrorMapper;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class PIS500ErrorMapper
extends Psd2ErrorMapper<MessageError, Error500NGPIS> {
    @Override
    public Function<MessageError, Error500NGPIS> getMapper() {
        return this::mapToPsd2Error;
    }

    @Override
    public HttpStatus getErrorStatus() {
        return HttpStatus.INTERNAL_SERVER_ERROR;
    }

    private Error500NGPIS mapToPsd2Error(MessageError messageError) {
        return new Error500NGPIS().tppMessages(this.mapToTppMessage500PIS(messageError.getTppMessages()));
    }

    private List<TppMessage500PIS> mapToTppMessage500PIS(Set<TppMessageInformation> tppMessages) {
        return tppMessages.stream().map(m -> new TppMessage500PIS().category(TppMessageCategory.fromValue((String)m.getCategory().name())).code(MessageCode500PIS.fromValue(m.getMessageErrorCode().getName())).path(m.getPath()).text(this.getErrorText((TppMessageInformation)m))).collect(Collectors.toList());
    }
}

