/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.consent;

import de.adorsys.psd2.consent.api.AspspDataService;
import de.adorsys.psd2.consent.api.service.PisCommonPaymentServiceEncrypted;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Service;

@Service
public class PisAspspDataService {
    private final PisCommonPaymentServiceEncrypted pisCommonPaymentServiceEncrypted;
    private final AspspDataService aspspDataService;

    public AspspConsentData getAspspConsentData(String paymentId) {
        return this.aspspDataService.readAspspConsentData(paymentId).orElseGet(() -> new AspspConsentData(null, paymentId));
    }

    public void updateAspspConsentData(AspspConsentData consentData) {
        this.aspspDataService.updateAspspConsentData(consentData);
    }

    public String getInternalPaymentIdByEncryptedString(String encryptedId) {
        return this.pisCommonPaymentServiceEncrypted.getDecryptedId(encryptedId).orElse(null);
    }

    @ConstructorProperties(value={"pisCommonPaymentServiceEncrypted", "aspspDataService"})
    public PisAspspDataService(PisCommonPaymentServiceEncrypted pisCommonPaymentServiceEncrypted, AspspDataService aspspDataService) {
        this.pisCommonPaymentServiceEncrypted = pisCommonPaymentServiceEncrypted;
        this.aspspDataService = aspspDataService;
    }
}

