/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.domain.ScaApproachHolder;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class ScaApproachResolver {
    private final AspspProfileService aspspProfileService;
    private final RequestProviderService requestProviderService;
    private final ScaApproachHolder scaApproachHolder;

    public ScaApproach resolveScaApproach() {
        if (this.scaApproachHolder.isNotEmpty()) {
            return this.scaApproachHolder.getScaApproach();
        }
        List scaApproaches = this.aspspProfileService.getScaApproaches();
        ScaApproach firstScaApproach = this.getFirst(scaApproaches);
        Optional<Boolean> tppRedirectPreferredOptional = this.requestProviderService.resolveTppRedirectPreferred();
        if (!tppRedirectPreferredOptional.isPresent()) {
            return firstScaApproach;
        }
        boolean tppRedirectPreferred = tppRedirectPreferredOptional.get();
        if (tppRedirectPreferred && scaApproaches.contains(ScaApproach.REDIRECT)) {
            return ScaApproach.REDIRECT;
        }
        if (!tppRedirectPreferred && ScaApproach.REDIRECT == firstScaApproach && scaApproaches.size() > 1) {
            return this.getSecond(scaApproaches);
        }
        return firstScaApproach;
    }

    public void forceDecoupledScaApproach() {
        this.scaApproachHolder.setScaApproach(ScaApproach.DECOUPLED);
    }

    private ScaApproach getFirst(List<ScaApproach> scaApproaches) {
        return scaApproaches.get(0);
    }

    private ScaApproach getSecond(List<ScaApproach> scaApproaches) {
        return scaApproaches.get(1);
    }

    @ConstructorProperties(value={"aspspProfileService", "requestProviderService", "scaApproachHolder"})
    public ScaApproachResolver(AspspProfileService aspspProfileService, RequestProviderService requestProviderService, ScaApproachHolder scaApproachHolder) {
        this.aspspProfileService = aspspProfileService;
        this.requestProviderService = requestProviderService;
        this.scaApproachHolder = scaApproachHolder;
    }
}

