/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.xs2a.core.event.EventType;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthorisationSubResources;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataRequest;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataResponse;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.PaymentAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.pis.PisScaAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.pis.PisScaAuthorisationServiceResolver;
import de.adorsys.psd2.xs2a.service.consent.Xs2aPisCommonPaymentService;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.pis.CommonPaymentObject;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.initiation.CreatePisAuthorisationValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.initiation.GetPaymentInitiationAuthorisationScaStatusValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.initiation.GetPaymentInitiationAuthorisationsValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.initiation.UpdatePisCommonPaymentPsuDataPO;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.initiation.UpdatePisCommonPaymentPsuDataValidator;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class PaymentAuthorisationServiceImpl
implements PaymentAuthorisationService {
    private static final String PAYMENT_NOT_FOUND_MESSAGE = "Payment not found";
    private final Xs2aEventService xs2aEventService;
    private final PisScaAuthorisationServiceResolver pisScaAuthorisationServiceResolver;
    private final Xs2aPisCommonPaymentService pisCommonPaymentService;
    private final CreatePisAuthorisationValidator createPisAuthorisationValidator;
    private final UpdatePisCommonPaymentPsuDataValidator updatePisCommonPaymentPsuDataValidator;
    private final GetPaymentInitiationAuthorisationsValidator getPaymentAuthorisationsValidator;
    private final GetPaymentInitiationAuthorisationScaStatusValidator getPaymentAuthorisationScaStatusValidator;

    @Override
    public ResponseObject<Xs2aCreatePisAuthorisationResponse> createPisAuthorization(String paymentId, PaymentType paymentType, String paymentProduct, PsuIdData psuData) {
        this.xs2aEventService.recordPisTppRequest(paymentId, EventType.START_PAYMENT_AUTHORISATION_REQUEST_RECEIVED);
        Optional<PisCommonPaymentResponse> pisCommonPaymentResponse = this.pisCommonPaymentService.getPisCommonPaymentById(paymentId);
        if (!pisCommonPaymentResponse.isPresent()) {
            return ResponseObject.builder().fail(ErrorType.PIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404, PAYMENT_NOT_FOUND_MESSAGE)).build();
        }
        ValidationResult validationResult = this.createPisAuthorisationValidator.validate(new CommonPaymentObject(pisCommonPaymentResponse.get()));
        if (validationResult.isNotValid()) {
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        PisScaAuthorisationService pisScaAuthorisationService = (PisScaAuthorisationService)this.pisScaAuthorisationServiceResolver.getService();
        return pisScaAuthorisationService.createCommonPaymentAuthorisation(paymentId, paymentType, psuData).map(resp -> ResponseObject.builder().body((Xs2aCreatePisAuthorisationResponse)resp).build()).orElseGet(ResponseObject.builder().fail(ErrorType.PIS_400, TppMessageInformation.of(MessageErrorCode.PAYMENT_FAILED))::build);
    }

    @Override
    public ResponseObject<Xs2aUpdatePisCommonPaymentPsuDataResponse> updatePisCommonPaymentPsuData(Xs2aUpdatePisCommonPaymentPsuDataRequest request) {
        this.xs2aEventService.recordPisTppRequest(request.getPaymentId(), EventType.UPDATE_PAYMENT_AUTHORISATION_PSU_DATA_REQUEST_RECEIVED, request);
        Optional<PisCommonPaymentResponse> pisCommonPaymentResponse = this.pisCommonPaymentService.getPisCommonPaymentById(request.getPaymentId());
        if (!pisCommonPaymentResponse.isPresent()) {
            return ResponseObject.builder().fail(ErrorType.PIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404, PAYMENT_NOT_FOUND_MESSAGE)).build();
        }
        ValidationResult validationResult = this.updatePisCommonPaymentPsuDataValidator.validate(new UpdatePisCommonPaymentPsuDataPO(pisCommonPaymentResponse.get(), request.getAuthorisationId()));
        if (validationResult.isNotValid()) {
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        PisScaAuthorisationService pisScaAuthorisationService = (PisScaAuthorisationService)this.pisScaAuthorisationServiceResolver.getService();
        Xs2aUpdatePisCommonPaymentPsuDataResponse response = pisScaAuthorisationService.updateCommonPaymentPsuData(request);
        if (response.hasError()) {
            return ResponseObject.builder().fail(new MessageError(response.getErrorHolder())).build();
        }
        return ResponseObject.builder().body(response).build();
    }

    @Override
    public ResponseObject<Xs2aAuthorisationSubResources> getPaymentInitiationAuthorisations(String paymentId) {
        this.xs2aEventService.recordPisTppRequest(paymentId, EventType.GET_PAYMENT_AUTHORISATION_REQUEST_RECEIVED);
        Optional<PisCommonPaymentResponse> pisCommonPaymentResponse = this.pisCommonPaymentService.getPisCommonPaymentById(paymentId);
        if (!pisCommonPaymentResponse.isPresent()) {
            return ResponseObject.builder().fail(ErrorType.PIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404, PAYMENT_NOT_FOUND_MESSAGE)).build();
        }
        ValidationResult validationResult = this.getPaymentAuthorisationsValidator.validate(new CommonPaymentObject(pisCommonPaymentResponse.get()));
        if (validationResult.isNotValid()) {
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        PisScaAuthorisationService pisScaAuthorisationService = (PisScaAuthorisationService)this.pisScaAuthorisationServiceResolver.getService();
        return pisScaAuthorisationService.getAuthorisationSubResources(paymentId).map(resp -> ResponseObject.builder().body((Xs2aAuthorisationSubResources)resp).build()).orElseGet(ResponseObject.builder().fail(ErrorType.PIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404))::build);
    }

    @Override
    public ResponseObject<ScaStatus> getPaymentInitiationAuthorisationScaStatus(String paymentId, String authorisationId) {
        this.xs2aEventService.recordPisTppRequest(paymentId, EventType.GET_PAYMENT_SCA_STATUS_REQUEST_RECEIVED);
        Optional<PisCommonPaymentResponse> pisCommonPaymentResponse = this.pisCommonPaymentService.getPisCommonPaymentById(paymentId);
        if (!pisCommonPaymentResponse.isPresent()) {
            return ResponseObject.builder().fail(ErrorType.PIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404, PAYMENT_NOT_FOUND_MESSAGE)).build();
        }
        ValidationResult validationResult = this.getPaymentAuthorisationScaStatusValidator.validate(new CommonPaymentObject(pisCommonPaymentResponse.get()));
        if (validationResult.isNotValid()) {
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        PisScaAuthorisationService pisScaAuthorisationService = (PisScaAuthorisationService)this.pisScaAuthorisationServiceResolver.getService();
        Optional<ScaStatus> scaStatus = pisScaAuthorisationService.getAuthorisationScaStatus(paymentId, authorisationId);
        if (!scaStatus.isPresent()) {
            return ResponseObject.builder().fail(ErrorType.PIS_403, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_403)).build();
        }
        return ResponseObject.builder().body(scaStatus.get()).build();
    }

    @ConstructorProperties(value={"xs2aEventService", "pisScaAuthorisationServiceResolver", "pisCommonPaymentService", "createPisAuthorisationValidator", "updatePisCommonPaymentPsuDataValidator", "getPaymentAuthorisationsValidator", "getPaymentAuthorisationScaStatusValidator"})
    public PaymentAuthorisationServiceImpl(Xs2aEventService xs2aEventService, PisScaAuthorisationServiceResolver pisScaAuthorisationServiceResolver, Xs2aPisCommonPaymentService pisCommonPaymentService, CreatePisAuthorisationValidator createPisAuthorisationValidator, UpdatePisCommonPaymentPsuDataValidator updatePisCommonPaymentPsuDataValidator, GetPaymentInitiationAuthorisationsValidator getPaymentAuthorisationsValidator, GetPaymentInitiationAuthorisationScaStatusValidator getPaymentAuthorisationScaStatusValidator) {
        this.xs2aEventService = xs2aEventService;
        this.pisScaAuthorisationServiceResolver = pisScaAuthorisationServiceResolver;
        this.pisCommonPaymentService = pisCommonPaymentService;
        this.createPisAuthorisationValidator = createPisAuthorisationValidator;
        this.updatePisCommonPaymentPsuDataValidator = updatePisCommonPaymentPsuDataValidator;
        this.getPaymentAuthorisationsValidator = getPaymentAuthorisationsValidator;
        this.getPaymentAuthorisationScaStatusValidator = getPaymentAuthorisationScaStatusValidator;
    }
}

