/*
 * Copyright 2018-2019 adorsys GmbH & Co KG
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.adorsys.psd2.xs2a.web.validator;

import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

@Component
@RequiredArgsConstructor
public abstract class AbstractHeadersValidator implements HeadersValidator {

    @Override
    public final boolean validate(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        if (!validateThis(request, response, handler)) {
            return false;
        }

        HeadersValidator nextValidator = getNextValidator();

        if (nextValidator != null) {
            return nextValidator.validate(request, response, handler);
        }

        return true;
    }

    protected abstract boolean validateThis(HttpServletRequest httpServletRequest, HttpServletResponse response, Object handler) throws IOException;

    protected abstract HeadersValidator getNextValidator();

}
