/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator;

import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.web.validator.MethodValidator;
import de.adorsys.psd2.xs2a.web.validator.body.BodyValidator;
import de.adorsys.psd2.xs2a.web.validator.header.HeaderValidator;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractMethodValidator<H extends HeaderValidator, B extends BodyValidator>
implements MethodValidator {
    private final List<H> headerValidators;
    private final List<B> bodyValidators;

    protected AbstractMethodValidator(List<H> headerValidators, List<B> bodyValidators) {
        this.headerValidators = headerValidators;
        this.bodyValidators = bodyValidators;
    }

    List<H> getHeaderValidators() {
        return this.headerValidators;
    }

    List<B> getBodyValidators() {
        return this.bodyValidators;
    }

    @Override
    public void validate(HttpServletRequest request, MessageError messageError) {
        Map<String, String> headers = Collections.list(request.getHeaderNames()).stream().collect(Collectors.toMap(h -> h, arg_0 -> ((HttpServletRequest)request).getHeader(arg_0)));
        TreeMap<String, String> caseInsensitiveHeaders = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        caseInsensitiveHeaders.putAll(headers);
        this.getHeaderValidators().forEach(v -> v.validate(caseInsensitiveHeaders, messageError));
        this.getBodyValidators().forEach(v -> v.validate(request, messageError));
    }
}

