/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.link;

import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationResponse;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.web.RedirectLinkBuilder;
import de.adorsys.psd2.xs2a.web.link.AbstractLinks;
import java.util.EnumSet;

public class PaymentInitiationLinks
extends AbstractLinks {
    private ScaApproachResolver scaApproachResolver;
    private RedirectLinkBuilder redirectLinkBuilder;
    private boolean isExplicitMethod;

    public PaymentInitiationLinks(String httpUrl, ScaApproachResolver scaApproachResolver, RedirectLinkBuilder redirectLinkBuilder, PaymentInitiationParameters paymentRequestParameters, PaymentInitiationResponse body, boolean isExplicitMethod) {
        super(httpUrl);
        this.scaApproachResolver = scaApproachResolver;
        this.redirectLinkBuilder = redirectLinkBuilder;
        this.isExplicitMethod = isExplicitMethod;
        this.buildPaymentLinks(paymentRequestParameters, body);
    }

    private void buildPaymentLinks(PaymentInitiationParameters paymentRequestParameters, PaymentInitiationResponse body) {
        if (TransactionStatus.RJCT == body.getTransactionStatus()) {
            return;
        }
        String paymentService = paymentRequestParameters.getPaymentType().getValue();
        String paymentProduct = paymentRequestParameters.getPaymentProduct();
        String paymentId = body.getPaymentId();
        this.setSelf(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}", paymentService, paymentProduct, paymentId));
        this.setStatus(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/status", paymentService, paymentProduct, paymentId));
        ScaApproach scaApproach = this.scaApproachResolver.resolveScaApproach();
        if (EnumSet.of(ScaApproach.EMBEDDED, ScaApproach.DECOUPLED).contains(scaApproach)) {
            this.addEmbeddedDecoupledRelatedLinks(paymentRequestParameters, body);
        } else if (scaApproach == ScaApproach.REDIRECT) {
            this.addRedirectRelatedLinks(paymentRequestParameters, body);
        } else if (scaApproach == ScaApproach.OAUTH) {
            this.setScaOAuth("scaOAuth");
        }
    }

    private void addEmbeddedDecoupledRelatedLinks(PaymentInitiationParameters paymentRequestParameters, PaymentInitiationResponse body) {
        String paymentService = paymentRequestParameters.getPaymentType().getValue();
        String paymentProduct = paymentRequestParameters.getPaymentProduct();
        String paymentId = body.getPaymentId();
        String authorizationId = body.getAuthorizationId();
        if (this.isExplicitMethod) {
            boolean isSigningBasketSupported;
            boolean bl = isSigningBasketSupported = !body.isMultilevelScaRequired();
            if (isSigningBasketSupported) {
                this.setStartAuthorisation(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/authorisations", paymentService, paymentProduct, paymentId));
            } else if (paymentRequestParameters.getPsuData().isEmpty()) {
                this.setStartAuthorisationWithPsuIdentification(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/authorisations", paymentService, paymentProduct, paymentId));
            } else {
                this.setStartAuthorisationWithPsuAuthentication(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/authorisations", paymentService, paymentProduct, paymentId));
            }
        } else {
            this.setScaStatus(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/authorisations/{authorisation-id}", paymentService, paymentProduct, paymentId, authorizationId));
            if (paymentRequestParameters.getPsuData().isEmpty()) {
                this.setUpdatePsuIdentification(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/authorisations/{authorisation-id}", paymentService, paymentProduct, paymentId, authorizationId));
            } else {
                this.setUpdatePsuAuthentication(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/authorisations/{authorisation-id}", paymentService, paymentProduct, paymentId, authorizationId));
            }
        }
    }

    private void addRedirectRelatedLinks(PaymentInitiationParameters paymentRequestParameters, PaymentInitiationResponse body) {
        String paymentService = paymentRequestParameters.getPaymentType().getValue();
        String paymentProduct = paymentRequestParameters.getPaymentProduct();
        String paymentId = body.getPaymentId();
        String authorisationId = body.getAuthorizationId();
        if (this.isExplicitMethod) {
            this.setStartAuthorisation(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/authorisations", paymentService, paymentProduct, paymentId));
        } else {
            String scaRedirectLink = this.redirectLinkBuilder.buildPaymentScaRedirectLink(body.getPaymentId(), authorisationId);
            this.setScaRedirect(scaRedirectLink);
            this.setScaStatus(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/authorisations/{authorisation-id}", paymentService, paymentProduct, paymentId, authorisationId));
        }
    }
}

