/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.link;

import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentResponse;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.web.RedirectLinkBuilder;
import de.adorsys.psd2.xs2a.web.link.AbstractLinks;
import java.util.EnumSet;

public class CreateConsentLinks
extends AbstractLinks {
    public CreateConsentLinks(String httpUrl, ScaApproachResolver scaApproachResolver, CreateConsentResponse response, RedirectLinkBuilder redirectLinkBuilder, boolean isExplicitMethod, PsuIdData psuData) {
        super(httpUrl);
        ScaApproach scaApproach;
        String consentId = response.getConsentId();
        String authorizationId = response.getAuthorizationId();
        this.setSelf(this.buildPath("/v1/consents/{consentId}", consentId));
        this.setStatus(this.buildPath("/v1/consents/{consentId}/status", consentId));
        String authorisationId = response.getAuthorizationId();
        ScaApproach scaApproach2 = scaApproach = authorisationId == null ? scaApproachResolver.resolveScaApproach() : scaApproachResolver.getInitiationScaApproach(authorisationId);
        if (EnumSet.of(ScaApproach.EMBEDDED, ScaApproach.DECOUPLED).contains(scaApproach)) {
            this.buildLinkForEmbeddedAndDecoupledScaApproach(response, psuData, consentId, authorizationId, isExplicitMethod);
        } else if (ScaApproach.REDIRECT == scaApproach) {
            if (isExplicitMethod) {
                this.setStartAuthorisation(this.buildPath("/v1/consents/{consentId}/authorisations", consentId));
            } else {
                this.setScaRedirect(redirectLinkBuilder.buildConsentScaRedirectLink(consentId, authorizationId));
                this.setScaStatus(this.buildPath("/v1/consents/{consentId}/authorisations/{authorisation-id}", consentId, authorizationId));
            }
        }
    }

    private void buildLinkForEmbeddedAndDecoupledScaApproach(CreateConsentResponse response, PsuIdData psuData, String consentId, String authorizationId, boolean isExplicitMethod) {
        if (isExplicitMethod) {
            boolean isSigningBasketSupported;
            boolean bl = isSigningBasketSupported = !response.isMultilevelScaRequired();
            if (isSigningBasketSupported) {
                this.setStartAuthorisation(this.buildPath("/v1/consents/{consentId}/authorisations", consentId));
            } else if (psuData.isEmpty()) {
                this.setStartAuthorisationWithPsuIdentification(this.buildPath("/v1/consents/{consentId}/authorisations", consentId));
            } else {
                this.setStartAuthorisationWithPsuAuthentication(this.buildPath("/v1/consents/{consentId}/authorisations", consentId));
            }
        } else {
            this.setScaStatus(this.buildPath("/v1/consents/{consentId}/authorisations/{authorisation-id}", consentId, authorizationId));
            if (psuData.isEmpty()) {
                this.setUpdatePsuIdentification(this.buildPath("/v1/consents/{consentId}/authorisations/{authorisation-id}", consentId, authorizationId));
            } else {
                this.setUpdatePsuAuthentication(this.buildPath("/v1/consents/{consentId}/authorisations/{authorisation-id}", consentId, authorizationId));
            }
        }
    }
}

