/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web;

import de.adorsys.psd2.xs2a.service.RequestProviderService;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.MapUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LinkExtractor {
    private static final Logger log = LoggerFactory.getLogger(LinkExtractor.class);
    private static final String HREF = "href";
    private final RequestProviderService requestProviderService;

    public Optional<String> extract(Map<?, ?> linksMap, @NotNull String linkName) {
        if (MapUtils.isEmpty(linksMap)) {
            log.info("X-Request-ID: [{}]. Couldn't extract the {} link from the  link map: map with links is null or empty", (Object)this.requestProviderService.getRequestId(), (Object)linkName);
            return Optional.empty();
        }
        Object linkObject = linksMap.get(linkName);
        if (this.isNotInstanceOfMap(linkObject)) {
            log.info("X-Request-ID: [{}]. Couldn't extract the {} link from the response: link is null or is not wrapped in the Map object", (Object)this.requestProviderService.getRequestId(), (Object)linkName);
            return Optional.empty();
        }
        return Optional.ofNullable(((Map)linkObject).get(HREF)).map(Object::toString);
    }

    private boolean isNotInstanceOfMap(Object object) {
        return !(object instanceof Map);
    }

    @ConstructorProperties(value={"requestProviderService"})
    public LinkExtractor(RequestProviderService requestProviderService) {
        this.requestProviderService = requestProviderService;
    }
}

