/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.account;

import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.ais.AbstractAisTppValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.AccountConsentValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.PermittedAccountReferenceValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.CommonAccountRequestObject;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class GetTransactionsReportValidator
extends AbstractAisTppValidator<CommonAccountRequestObject> {
    private final PermittedAccountReferenceValidator permittedAccountReferenceValidator;
    private final AccountConsentValidator accountConsentValidator;

    @Override
    @NotNull
    protected ValidationResult executeBusinessValidation(CommonAccountRequestObject commonAccountRequestObject) {
        AccountConsent accountConsent = commonAccountRequestObject.getAccountConsent();
        ValidationResult permittedAccountReferenceValidationResult = this.permittedAccountReferenceValidator.validate(accountConsent, commonAccountRequestObject.getTransactions(), commonAccountRequestObject.getAccountId(), commonAccountRequestObject.isWithBalance());
        if (permittedAccountReferenceValidationResult.isNotValid()) {
            return permittedAccountReferenceValidationResult;
        }
        return this.accountConsentValidator.validate(accountConsent, commonAccountRequestObject.getRequestUri());
    }

    @ConstructorProperties(value={"permittedAccountReferenceValidator", "accountConsentValidator"})
    public GetTransactionsReportValidator(PermittedAccountReferenceValidator permittedAccountReferenceValidator, AccountConsentValidator accountConsentValidator) {
        this.permittedAccountReferenceValidator = permittedAccountReferenceValidator;
        this.accountConsentValidator = accountConsentValidator;
    }
}

