/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator;

import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.header.HeadersFactory;
import de.adorsys.psd2.xs2a.service.validator.header.RequestHeader;
import de.adorsys.psd2.xs2a.service.validator.header.impl.ErrorMessageHeaderImpl;
import de.adorsys.psd2.xs2a.service.validator.header.impl.PaymentInitiationRequestHeader;
import de.adorsys.psd2.xs2a.service.validator.parameter.ParametersFactory;
import de.adorsys.psd2.xs2a.service.validator.parameter.RequestParameter;
import de.adorsys.psd2.xs2a.service.validator.parameter.impl.ErrorMessageParameterImpl;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerMapping;

@Deprecated
public class RequestValidatorService {
    private static final Logger log = LoggerFactory.getLogger(RequestValidatorService.class);
    @Autowired
    private ParametersFactory parametersFactory;
    @Autowired
    private Validator validator;
    @Autowired
    private AspspProfileServiceWrapper aspspProfileServiceWrapper;
    private static final String PAYMENT_PRODUCT_PATH_VAR = "payment-product";
    private static final String PAYMENT_SERVICE_PATH_VAR = "payment-service";

    public Map<String, String> getRequestViolationMap(HttpServletRequest request, Object handler) {
        HashMap<String, String> violationMap = new HashMap<String, String>();
        if (handler instanceof CorsConfigurationSource) {
            return violationMap;
        }
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            violationMap.putAll(this.getRequestHeaderViolationMap(request, handlerMethod));
            violationMap.putAll(this.getRequestParametersViolationMap(request, handlerMethod));
            violationMap.putAll(this.getRequestPathVariablesViolationMap(request));
        }
        return violationMap;
    }

    public Map<String, String> getRequestViolationMapInitiatePayment(Map<String, String> requestHeadersMap) {
        RequestHeader headerImpl = HeadersFactory.getHeadersImplByRequestHeaderClass(requestHeadersMap, PaymentInitiationRequestHeader.class);
        if (headerImpl instanceof ErrorMessageHeaderImpl) {
            return Collections.singletonMap("Wrong header arguments: ", ((ErrorMessageHeaderImpl)headerImpl).getErrorMessage());
        }
        return this.getViolationMessagesMap(this.validator.validate((Object)headerImpl, new Class[0]));
    }

    public Map<String, String> getRequestViolationMapInitiatePayment(HttpServletRequest request) {
        Map<String, String> requestHeadersMap = this.getRequestHeadersMap(request);
        return this.getRequestViolationMapInitiatePayment(requestHeadersMap);
    }

    private Map<String, String> getRequestParametersViolationMap(HttpServletRequest request, HandlerMethod handler) {
        Map<String, String> requestParameterMap = this.getRequestParametersMap(request);
        RequestParameter parameterImpl = this.parametersFactory.getParameterImpl(requestParameterMap, handler.getBeanType());
        if (parameterImpl instanceof ErrorMessageParameterImpl) {
            return Collections.singletonMap("Wrong parameters : ", ((ErrorMessageParameterImpl)parameterImpl).getErrorMessage());
        }
        return this.getViolationMessagesMap(this.validator.validate((Object)parameterImpl, new Class[0]));
    }

    private Map<String, String> getRequestPathVariablesViolationMap(HttpServletRequest request) {
        HashMap<String, String> requestPathViolationMap = new HashMap<String, String>();
        requestPathViolationMap.putAll(this.getViolationMapForPaymentTypeAndPaymentProduct(request));
        return requestPathViolationMap;
    }

    private Map<String, String> getViolationMapForPaymentTypeAndPaymentProduct(HttpServletRequest request) {
        Map<String, String> pathVariableMap = this.getPathVariableMap(request);
        Optional<PaymentType> paymentType = this.getPaymentTypeFromRequest(pathVariableMap);
        Optional<String> paymentProduct = this.getPaymentProductFromRequest(pathVariableMap);
        if (paymentType.isPresent() && paymentProduct.isPresent()) {
            return this.arePaymentTypeAndProductAvailable(paymentType.get(), paymentProduct.get());
        }
        return Collections.emptyMap();
    }

    private Optional<String> getPaymentProductFromRequest(Map<String, String> pathVariableMap) {
        return Optional.ofNullable(pathVariableMap).map(mp -> (String)mp.get(PAYMENT_PRODUCT_PATH_VAR));
    }

    private Optional<PaymentType> getPaymentTypeFromRequest(Map<String, String> pathVariableMap) {
        return Optional.ofNullable(pathVariableMap).map(m -> (String)m.get(PAYMENT_SERVICE_PATH_VAR)).flatMap(PaymentType::getByValue);
    }

    private Map<String, String> arePaymentTypeAndProductAvailable(PaymentType paymentType, String paymentProduct) {
        Map<PaymentType, Set<String>> supportedPaymentTypeAndProductMatrix = this.aspspProfileServiceWrapper.getSupportedPaymentTypeAndProductMatrix();
        if (supportedPaymentTypeAndProductMatrix.containsKey(paymentType)) {
            if (supportedPaymentTypeAndProductMatrix.get(paymentType).contains(paymentProduct)) {
                return Collections.emptyMap();
            }
            return Collections.singletonMap(MessageErrorCode.PRODUCT_UNKNOWN.getName(), "Wrong payment product: " + paymentProduct);
        }
        return Collections.singletonMap(MessageErrorCode.PARAMETER_NOT_SUPPORTED.getName(), "Wrong payment type: " + paymentType.getValue());
    }

    private Map<String, String> getRequestHeaderViolationMap(HttpServletRequest request, HandlerMethod handler) {
        Map<String, String> requestHeadersMap = this.getRequestHeadersMap(request);
        RequestHeader headerImpl = HeadersFactory.getHeadersImpl(requestHeadersMap, handler.getBeanType());
        if (headerImpl instanceof ErrorMessageHeaderImpl) {
            return Collections.singletonMap("Wrong header arguments: ", ((ErrorMessageHeaderImpl)headerImpl).getErrorMessage());
        }
        return this.getViolationMessagesMap(this.validator.validate((Object)headerImpl, new Class[0]));
    }

    private Map<String, String> getRequestHeadersMap(HttpServletRequest request) {
        HashMap<String, String> requestHeaderMap = new HashMap<String, String>();
        if (request == null) {
            return requestHeaderMap;
        }
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = request.getHeader(key);
            requestHeaderMap.put(key, value);
        }
        return requestHeaderMap;
    }

    private Map<String, String> getRequestParametersMap(HttpServletRequest request) {
        return request.getParameterMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> String.join((CharSequence)",", (CharSequence[])e.getValue())));
    }

    private <T> Map<String, String> getViolationMessagesMap(Set<ConstraintViolation<T>> collection) {
        return collection.stream().collect(Collectors.toMap(violation -> violation.getPropertyPath().toString(), violation -> "'" + violation.getPropertyPath().toString() + "' " + violation.getMessage()));
    }

    private Map<String, String> getPathVariableMap(HttpServletRequest request) {
        return (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
    }
}

