/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.domain.address.Xs2aAddress;
import de.adorsys.psd2.xs2a.domain.address.Xs2aCountryCode;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiAddress;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Component;

@Component
public class SpiToXs2aAddressMapper {
    public Xs2aAddress mapToAddress(@NotNull SpiAddress creditorAddress) {
        return Optional.ofNullable(creditorAddress).map(a -> {
            Xs2aAddress address = new Xs2aAddress();
            address.setCountry(new Xs2aCountryCode(a.getCountry()));
            address.setPostalCode(a.getPostalCode());
            address.setCity(a.getCity());
            address.setStreet(a.getStreet());
            address.setBuildingNumber(a.getBuildingNumber());
            return address;
        }).orElseGet(Xs2aAddress::new);
    }
}

