/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.psd2.sb;

import de.adorsys.psd2.model.Error400NGSBS;
import de.adorsys.psd2.model.MessageCode400SBS;
import de.adorsys.psd2.model.TppMessage400SBS;
import de.adorsys.psd2.model.TppMessageCategory;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.mapper.psd2.Psd2ErrorMapper;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class SB400ErrorMapper
extends Psd2ErrorMapper<MessageError, Error400NGSBS> {
    @Override
    public Function<MessageError, Error400NGSBS> getMapper() {
        return this::mapToPsd2Error;
    }

    @Override
    public HttpStatus getErrorStatus() {
        return HttpStatus.BAD_REQUEST;
    }

    private Error400NGSBS mapToPsd2Error(MessageError messageError) {
        return new Error400NGSBS().tppMessages(this.mapToTppMessage400SB(messageError.getTppMessages()));
    }

    private List<TppMessage400SBS> mapToTppMessage400SB(Set<TppMessageInformation> tppMessages) {
        return tppMessages.stream().map(m -> new TppMessage400SBS().category(TppMessageCategory.fromValue((String)m.getCategory().name())).code(MessageCode400SBS.fromValue((String)m.getMessageErrorCode().getName())).path(m.getPath()).text(this.getErrorText((TppMessageInformation)m))).collect(Collectors.toList());
    }
}

