/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.consent;

import de.adorsys.psd2.consent.api.ActionStatus;
import de.adorsys.psd2.consent.api.ais.AisAccountAccessInfo;
import de.adorsys.psd2.consent.api.ais.AisConsentActionRequest;
import de.adorsys.psd2.consent.api.ais.AisConsentAuthorizationRequest;
import de.adorsys.psd2.consent.api.ais.CreateAisConsentAuthorizationResponse;
import de.adorsys.psd2.consent.api.ais.CreateAisConsentRequest;
import de.adorsys.psd2.consent.api.service.AisConsentAuthorisationServiceEncrypted;
import de.adorsys.psd2.consent.api.service.AisConsentServiceEncrypted;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.AuthorisationScaApproachResponse;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsentAuthorization;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthenticationObject;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAisConsentAuthorisationMapper;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAuthenticationObjectToCmsScaMethodMapper;
import de.adorsys.psd2.xs2a.service.profile.FrequencyPerDateCalculationService;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class Xs2aAisConsentService {
    private final AisConsentServiceEncrypted aisConsentService;
    private final AisConsentAuthorisationServiceEncrypted aisConsentAuthorisationServiceEncrypted;
    private final Xs2aAisConsentMapper aisConsentMapper;
    private final Xs2aAisConsentAuthorisationMapper aisConsentAuthorisationMapper;
    private final Xs2aAuthenticationObjectToCmsScaMethodMapper xs2AAuthenticationObjectToCmsScaMethodMapper;
    private final FrequencyPerDateCalculationService frequencyPerDateCalculationService;
    private final ScaApproachResolver scaApproachResolver;

    public String createConsent(CreateConsentReq request, PsuIdData psuData, TppInfo tppInfo) {
        int allowedFrequencyPerDay = this.frequencyPerDateCalculationService.getMinFrequencyPerDay(request.getFrequencyPerDay());
        CreateAisConsentRequest createAisConsentRequest = this.aisConsentMapper.mapToCreateAisConsentRequest(request, psuData, tppInfo, allowedFrequencyPerDay);
        Optional consent = this.aisConsentService.createConsent(createAisConsentRequest);
        return consent.orElse(null);
    }

    public Optional<AccountConsent> getAccountConsentById(String consentId) {
        return this.aisConsentService.getAisAccountConsentById(consentId).map(this.aisConsentMapper::mapToAccountConsent);
    }

    public Optional<AccountConsent> getInitialAccountConsentById(String consentId) {
        return this.aisConsentService.getInitialAisAccountConsentById(consentId).map(this.aisConsentMapper::mapToAccountConsent);
    }

    public Optional<ConsentStatus> getAccountConsentStatusById(String consentId) {
        return this.aisConsentService.getConsentStatusById(consentId);
    }

    public boolean findAndTerminateOldConsentsByNewConsentId(String newConsentId) {
        return this.aisConsentService.findAndTerminateOldConsentsByNewConsentId(newConsentId);
    }

    public void updateConsentStatus(String consentId, ConsentStatus consentStatus) {
        this.aisConsentService.updateConsentStatusById(consentId, consentStatus);
    }

    public void consentActionLog(String tppId, String consentId, ActionStatus actionStatus, String requestUri) {
        this.aisConsentService.checkConsentAndSaveActionLog(new AisConsentActionRequest(tppId, consentId, actionStatus, requestUri));
    }

    public Optional<CreateAisConsentAuthorizationResponse> createAisConsentAuthorization(String consentId, ScaStatus scaStatus, PsuIdData psuData) {
        AisConsentAuthorizationRequest request = this.aisConsentAuthorisationMapper.mapToAisConsentAuthorization(scaStatus, psuData, this.scaApproachResolver.resolveScaApproach());
        return this.aisConsentAuthorisationServiceEncrypted.createAuthorizationWithResponse(consentId, request);
    }

    public Optional<AccountConsentAuthorization> getAccountConsentAuthorizationById(String authorizationId, String consentId) {
        return this.aisConsentAuthorisationServiceEncrypted.getAccountConsentAuthorizationById(authorizationId, consentId).map(this.aisConsentAuthorisationMapper::mapToAccountConsentAuthorization);
    }

    public void updateConsentAuthorization(UpdateConsentPsuDataReq updatePsuData) {
        Optional.ofNullable(updatePsuData).ifPresent(req -> {
            String authorizationId = req.getAuthorizationId();
            AisConsentAuthorizationRequest request = this.aisConsentAuthorisationMapper.mapToAisConsentAuthorizationRequest((UpdateConsentPsuDataReq)req);
            this.aisConsentAuthorisationServiceEncrypted.updateConsentAuthorization(authorizationId, request);
        });
    }

    public Optional<AccountConsent> updateAspspAccountAccess(String consentId, AisAccountAccessInfo aisAccountAccessInfo) {
        return this.aisConsentService.updateAspspAccountAccessWithResponse(consentId, aisAccountAccessInfo).map(this.aisConsentMapper::mapToAccountConsent);
    }

    public Optional<List<String>> getAuthorisationSubResources(String consentId) {
        return this.aisConsentAuthorisationServiceEncrypted.getAuthorisationsByConsentId(consentId);
    }

    public Optional<ScaStatus> getAuthorisationScaStatus(String consentId, String authorisationId) {
        return this.aisConsentAuthorisationServiceEncrypted.getAuthorisationScaStatus(consentId, authorisationId);
    }

    public boolean isAuthenticationMethodDecoupled(String authorisationId, String authenticationMethodId) {
        return this.aisConsentAuthorisationServiceEncrypted.isAuthenticationMethodDecoupled(authorisationId, authenticationMethodId);
    }

    public boolean saveAuthenticationMethods(String authorisationId, List<Xs2aAuthenticationObject> methods) {
        return this.aisConsentAuthorisationServiceEncrypted.saveAuthenticationMethods(authorisationId, this.xs2AAuthenticationObjectToCmsScaMethodMapper.mapToCmsScaMethods(methods));
    }

    public void updateScaApproach(String authorisationId, ScaApproach scaApproach) {
        this.aisConsentAuthorisationServiceEncrypted.updateScaApproach(authorisationId, scaApproach);
    }

    public void updateMultilevelScaRequired(String consentId, boolean multilevelScaRequired) {
        this.aisConsentService.updateMultilevelScaRequired(consentId, multilevelScaRequired);
    }

    public Optional<AuthorisationScaApproachResponse> getAuthorisationScaApproach(String authorisationId) {
        return this.aisConsentAuthorisationServiceEncrypted.getAuthorisationScaApproach(authorisationId);
    }

    @ConstructorProperties(value={"aisConsentService", "aisConsentAuthorisationServiceEncrypted", "aisConsentMapper", "aisConsentAuthorisationMapper", "xs2AAuthenticationObjectToCmsScaMethodMapper", "frequencyPerDateCalculationService", "scaApproachResolver"})
    public Xs2aAisConsentService(AisConsentServiceEncrypted aisConsentService, AisConsentAuthorisationServiceEncrypted aisConsentAuthorisationServiceEncrypted, Xs2aAisConsentMapper aisConsentMapper, Xs2aAisConsentAuthorisationMapper aisConsentAuthorisationMapper, Xs2aAuthenticationObjectToCmsScaMethodMapper xs2AAuthenticationObjectToCmsScaMethodMapper, FrequencyPerDateCalculationService frequencyPerDateCalculationService, ScaApproachResolver scaApproachResolver) {
        this.aisConsentService = aisConsentService;
        this.aisConsentAuthorisationServiceEncrypted = aisConsentAuthorisationServiceEncrypted;
        this.aisConsentMapper = aisConsentMapper;
        this.aisConsentAuthorisationMapper = aisConsentAuthorisationMapper;
        this.xs2AAuthenticationObjectToCmsScaMethodMapper = xs2AAuthenticationObjectToCmsScaMethodMapper;
        this.frequencyPerDateCalculationService = frequencyPerDateCalculationService;
        this.scaApproachResolver = scaApproachResolver;
    }
}

