/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.ais.stage.embedded;

import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.domain.consent.ConsentAuthorizationResponseLinkType;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.authorization.ais.stage.AisScaStage;
import de.adorsys.psd2.xs2a.service.consent.AisConsentDataService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiResponseStatusToXs2aMessageErrorCodeMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAuthenticationObjectMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPsuDataMapper;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiVerifyScaAuthorisationResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.AisConsentSpi;
import java.util.Collections;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service(value="AIS_SCAMETHODSELECTED")
public class AisScaAuthenticatedStage
extends AisScaStage<UpdateConsentPsuDataReq, UpdateConsentPsuDataResponse> {
    private final SpiContextDataProvider spiContextDataProvider;

    public AisScaAuthenticatedStage(Xs2aAisConsentService aisConsentService, AisConsentDataService aisConsentDataService, AisConsentSpi aisConsentSpi, Xs2aAisConsentMapper aisConsentMapper, SpiResponseStatusToXs2aMessageErrorCodeMapper messageErrorCodeMapper, Xs2aToSpiPsuDataMapper psuDataMapper, SpiToXs2aAuthenticationObjectMapper spiToXs2aAuthenticationObjectMapper, SpiContextDataProvider spiContextDataProvider, SpiErrorMapper spiErrorMapper) {
        super(aisConsentService, aisConsentDataService, aisConsentSpi, aisConsentMapper, messageErrorCodeMapper, psuDataMapper, spiToXs2aAuthenticationObjectMapper, spiErrorMapper);
        this.spiContextDataProvider = spiContextDataProvider;
    }

    @Override
    public UpdateConsentPsuDataResponse apply(UpdateConsentPsuDataReq request) {
        String consentId = request.getConsentId();
        Optional<AccountConsent> accountConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        if (!accountConsentOptional.isPresent()) {
            MessageError messageError = new MessageError(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_400));
            return this.createFailedResponse(messageError, Collections.emptyList(), request);
        }
        AccountConsent accountConsent = accountConsentOptional.get();
        PsuIdData psuData = this.extractPsuIdData(request);
        SpiResponse spiResponse = this.aisConsentSpi.verifyScaAuthorisation(this.spiContextDataProvider.provideWithPsuIdData(psuData), this.aisConsentMapper.mapToSpiScaConfirmation(request, psuData), this.aisConsentMapper.mapToSpiAccountConsent(accountConsent), this.aisConsentDataService.getAspspConsentDataByConsentId(consentId));
        this.aisConsentDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            MessageError messageError = new MessageError(this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS));
            return this.createFailedResponse(messageError, spiResponse.getMessages(), request);
        }
        ConsentStatus responseConsentStatus = ((SpiVerifyScaAuthorisationResponse)spiResponse.getPayload()).getConsentStatus();
        if (ConsentStatus.PARTIALLY_AUTHORISED == responseConsentStatus && !accountConsent.isMultilevelScaRequired()) {
            this.aisConsentService.updateMultilevelScaRequired(consentId, true);
        }
        if (accountConsent.getConsentStatus() != responseConsentStatus) {
            this.aisConsentService.updateConsentStatus(consentId, responseConsentStatus);
        }
        this.aisConsentService.findAndTerminateOldConsentsByNewConsentId(consentId);
        UpdateConsentPsuDataResponse response = new UpdateConsentPsuDataResponse(ScaStatus.FINALISED, consentId, request.getAuthorizationId());
        response.setScaAuthenticationData(request.getScaAuthenticationData());
        response.setResponseLinkType(ConsentAuthorizationResponseLinkType.START_AUTHORISATION_WITH_AUTHENTICATION_METHOD_SELECTION);
        return response;
    }
}

